<?php
/**
 * Buy form template
 */

if (!defined('ABSPATH')) exit;

$price = isset($atts['cena']) ? floatval($atts['cena']) : get_option('kr_shop_price', 1290);
?>

<div class="kr-buy-container">
    <div class="kr-buy-box">
        <div class="kr-buy-header">
            <h2>🎉 Koupit Kadeřnice Rezervace</h2>
            <div class="kr-buy-price"><?php echo number_format($price, 0, ',', ' '); ?> Kč</div>
        </div>
        
        <div class="kr-buy-features">
            <h3>✅ Co získáte:</h3>
            <ul>
                <li>✓ Plnou verzi pluginu bez omezení</li>
                <li>✓ Automatické aktualizace po dobu 1 roku</li>
                <li>✓ Technickou podporu</li>
                <li>✓ Přístup k dokumentaci</li>
                <li>✓ Neomezený počet rezervací</li>
                <li>✓ Email a SMS notifikace</li>
            </ul>
        </div>
        
        <form id="kr-buy-form" class="kr-buy-form">
            <div class="kr-form-row">
                <label for="kr-buy-name">Jméno a příjmení *</label>
                <input type="text" id="kr-buy-name" name="name" required placeholder="Jan Novák">
            </div>
            
            <div class="kr-form-row">
                <label for="kr-buy-email">Email *</label>
                <input type="email" id="kr-buy-email" name="email" required placeholder="jan@example.com">
            </div>
            
            <div class="kr-form-row">
                <label for="kr-buy-phone">Telefon</label>
                <input type="tel" id="kr-buy-phone" name="phone" placeholder="+420 123 456 789">
            </div>
            
            <div class="kr-form-row">
                <label for="kr-buy-company">Firma (volitelné)</label>
                <input type="text" id="kr-buy-company" name="company" placeholder="Název firmy">
            </div>
            
            <div class="kr-form-row">
                <label class="kr-checkbox-label">
                    <input type="checkbox" id="kr-buy-gdpr" required>
                    Souhlasím se zpracováním osobních údajů *
                </label>
            </div>
            
            <input type="hidden" name="price" value="<?php echo esc_attr($price); ?>">
            
            <button type="submit" class="kr-buy-submit">
                🛒 Objednat
            </button>
            
            <div id="kr-buy-message" class="kr-buy-message" style="display: none;"></div>
        </form>
        
        <div class="kr-buy-info">
            <p><strong>📋 Jak to funguje:</strong></p>
            <ol>
                <li>Vyplňte objednávkový formulář</li>
                <li>Obdržíte platební instrukce na email (včetně QR kódu)</li>
                <li>Proveďte platbu na náš účet</li>
                <li>Do 24 hodin obdržíte licenční klíč</li>
                <li>Stáhnete plugin a aktivujete licenci</li>
            </ol>
        </div>
    </div>
</div>

<style>
.kr-buy-container {
    max-width: 600px;
    margin: 40px auto;
    padding: 0 20px;
}

.kr-buy-box {
    background: white;
    border-radius: 16px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.kr-buy-header {
    background: linear-gradient(135deg, #f89820 0%, #ff6b35 100%);
    color: white;
    padding: 40px 30px;
    text-align: center;
}

.kr-buy-header h2 {
    margin: 0 0 20px 0;
    font-size: 28px;
}

.kr-buy-price {
    font-size: 48px;
    font-weight: bold;
}

.kr-buy-features {
    padding: 30px;
    background: #f8f9fa;
}

.kr-buy-features h3 {
    margin: 0 0 15px 0;
    color: #333;
}

.kr-buy-features ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.kr-buy-features li {
    padding: 8px 0;
    color: #555;
    font-size: 15px;
}

.kr-buy-form {
    padding: 30px;
}

.kr-form-row {
    margin-bottom: 20px;
}

.kr-form-row label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.kr-form-row input[type="text"],
.kr-form-row input[type="email"],
.kr-form-row input[type="tel"] {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 16px;
    transition: border-color 0.3s ease;
}

.kr-form-row input:focus {
    outline: none;
    border-color: #f89820;
}

.kr-checkbox-label {
    display: flex;
    align-items: center;
    cursor: pointer;
}

.kr-checkbox-label input {
    margin-right: 8px;
}

.kr-buy-submit {
    width: 100%;
    background: linear-gradient(135deg, #f89820 0%, #ff6b35 100%);
    color: white;
    border: none;
    padding: 16px;
    font-size: 18px;
    font-weight: bold;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.kr-buy-submit:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(248, 152, 32, 0.4);
}

.kr-buy-submit:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.kr-buy-message {
    padding: 16px;
    border-radius: 8px;
    margin-top: 20px;
    font-weight: 500;
}

.kr-buy-message.success {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.kr-buy-message.error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

.kr-buy-info {
    padding: 30px;
    background: #f8f9fa;
    border-top: 1px solid #e0e0e0;
}

.kr-buy-info p {
    margin: 0 0 15px 0;
    font-weight: 600;
    color: #333;
}

.kr-buy-info ol {
    margin: 0;
    padding-left: 20px;
}

.kr-buy-info li {
    padding: 5px 0;
    color: #555;
}

@media (max-width: 768px) {
    .kr-buy-header h2 {
        font-size: 22px;
    }
    
    .kr-buy-price {
        font-size: 36px;
    }
    
    .kr-buy-form {
        padding: 20px;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    $('#kr-buy-form').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $submit = $form.find('.kr-buy-submit');
        var $message = $('#kr-buy-message');
        
        // Disable button
        $submit.prop('disabled', true).text('⏳ Zpracovávám...');
        $message.hide().removeClass('success error');
        
        // Prepare data
        var formData = {
            action: 'kr_process_order',
            nonce: krAjax.nonce,
            name: $('#kr-buy-name').val(),
            email: $('#kr-buy-email').val(),
            phone: $('#kr-buy-phone').val(),
            company: $('#kr-buy-company').val()
        };
        
        // Send AJAX
        $.post(krAjax.ajaxUrl, formData, function(response) {
            if (response.success) {
                $message
                    .addClass('success')
                    .html('✅ ' + response.data.message)
                    .show();
                $form[0].reset();
            } else {
                $message
                    .addClass('error')
                    .html('❌ ' + response.data.message)
                    .show();
            }
        }).fail(function() {
            $message
                .addClass('error')
                .html('❌ Došlo k chybě. Zkuste to prosím znovu.')
                .show();
        }).always(function() {
            $submit.prop('disabled', false).text('🛒 Objednat');
        });
    });
});
</script>