<?php
/**
 * Booking form template
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="kr-booking-wrapper" data-theme="<?php echo esc_attr($atts['theme'] ?? 'default'); ?>">
    <div class="kr-booking-container">
        
        <!-- Step 1: Select Service(s) -->
        <div class="kr-step kr-step-service active" data-step="1">
            <div class="kr-step-header">
                <h3 class="kr-step-title"><?php _e('Vyberte služby', 'kadernice-rezervace'); ?></h3>
                <p class="kr-step-subtitle"><?php _e('Můžete vybrat více služeb najednou', 'kadernice-rezervace'); ?></p>
            </div>
            
            <!-- Selected Services Summary -->
            <div class="kr-selected-services" id="kr-selected-services" style="display: none;">
                <h4 class="kr-selected-title"><?php _e('Vybrané služby:', 'kadernice-rezervace'); ?></h4>
                <div class="kr-selected-list" id="kr-selected-list"></div>
                <div class="kr-selected-total">
                    <span><?php _e('Celková doba:', 'kadernice-rezervace'); ?></span>
                    <strong id="kr-total-duration">0 min</strong>
                    <span style="margin-left: 20px;"><?php _e('Celková cena:', 'kadernice-rezervace'); ?></span>
                    <strong id="kr-total-price">0 Kč</strong>
                </div>
            </div>
            
            <div class="kr-services-grid" id="kr-services-list">
                <div class="kr-loading"><?php _e('Načítání služeb...', 'kadernice-rezervace'); ?></div>
            </div>
            
            <div class="kr-step-actions">
                <button type="button" class="kr-btn kr-btn-primary kr-btn-continue" id="kr-continue-services" disabled>
                    <?php _e('Pokračovat', 'kadernice-rezervace'); ?> →
                </button>
            </div>
        </div>
        
        <!-- Step 2: Select Date -->
        <div class="kr-step kr-step-date" data-step="2">
            <h3 class="kr-step-title"><?php _e('Vyberte datum', 'kadernice-rezervace'); ?></h3>
            <div class="kr-calendar-container">
                <div class="kr-calendar-header">
                    <button type="button" class="kr-calendar-nav kr-prev-month" aria-label="<?php esc_attr_e('Předchozí měsíc', 'kadernice-rezervace'); ?>">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="15 18 9 12 15 6"></polyline>
                        </svg>
                    </button>
                    <h4 class="kr-calendar-month" id="kr-current-month"></h4>
                    <button type="button" class="kr-calendar-nav kr-next-month" aria-label="<?php esc_attr_e('Další měsíc', 'kadernice-rezervace'); ?>">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </button>
                </div>
                <div class="kr-calendar">
                    <div class="kr-calendar-weekdays">
                        <div class="kr-weekday"><?php _e('Po', 'kadernice-rezervace'); ?></div>
                        <div class="kr-weekday"><?php _e('Út', 'kadernice-rezervace'); ?></div>
                        <div class="kr-weekday"><?php _e('St', 'kadernice-rezervace'); ?></div>
                        <div class="kr-weekday"><?php _e('Čt', 'kadernice-rezervace'); ?></div>
                        <div class="kr-weekday"><?php _e('Pá', 'kadernice-rezervace'); ?></div>
                        <div class="kr-weekday"><?php _e('So', 'kadernice-rezervace'); ?></div>
                        <div class="kr-weekday"><?php _e('Ne', 'kadernice-rezervace'); ?></div>
                    </div>
                    <div class="kr-calendar-days" id="kr-calendar-days"></div>
                </div>
                
                <!-- Calendar Legend -->
                <div class="kr-calendar-legend">
                    <div class="kr-legend-item">
                        <div class="kr-legend-box available">✓</div>
                        <span><?php _e('Volné termíny', 'kadernice-rezervace'); ?></span>
                    </div>
                    <div class="kr-legend-item">
                        <div class="kr-legend-box partially">◐</div>
                        <span><?php _e('Částečně obsazeno', 'kadernice-rezervace'); ?></span>
                    </div>
                    <div class="kr-legend-item">
                        <div class="kr-legend-box booked">✕</div>
                        <span><?php _e('Plně obsazeno', 'kadernice-rezervace'); ?></span>
                    </div>
                    <div class="kr-legend-item">
                        <div class="kr-legend-box closed">🔒</div>
                        <span><?php _e('Zavřeno', 'kadernice-rezervace'); ?></span>
                    </div>
                    <div class="kr-legend-item">
                        <div class="kr-legend-box today"></div>
                        <span><?php _e('Dnešní den', 'kadernice-rezervace'); ?></span>
                    </div>
                </div>
            </div>
            
            <div class="kr-form-actions">
                <button type="button" class="kr-btn kr-btn-secondary kr-btn-back">
                    ← <?php _e('Zpět', 'kadernice-rezervace'); ?>
                </button>
            </div>
        </div>
        
        <!-- Step 3: Select Time -->
        <div class="kr-step kr-step-time" data-step="3">
            <h3 class="kr-step-title"><?php _e('Vyberte čas', 'kadernice-rezervace'); ?></h3>
            <div class="kr-times-grid" id="kr-times-list">
                <div class="kr-loading"><?php _e('Načítání dostupných časů...', 'kadernice-rezervace'); ?></div>
            </div>
            
            <div class="kr-form-actions">
                <button type="button" class="kr-btn kr-btn-secondary kr-btn-back">
                    ← <?php _e('Zpět', 'kadernice-rezervace'); ?>
                </button>
            </div>
        </div>
        
        <!-- Step 4: Customer Details -->
        <div class="kr-step kr-step-details" data-step="4">
            <h3 class="kr-step-title"><?php _e('Vaše údaje', 'kadernice-rezervace'); ?></h3>
            <p class="kr-step-subtitle"><?php _e('Vyplňte prosím své kontaktní údaje pro dokončení rezervace', 'kadernice-rezervace'); ?></p>
            
            <!-- Booking Summary Card -->
            <div class="kr-booking-summary-card">
                <div class="kr-summary-header">
                    <span class="kr-summary-icon">📋</span>
                    <h4><?php _e('Shrnutí rezervace', 'kadernice-rezervace'); ?></h4>
                </div>
                <div class="kr-booking-summary">
                    <div class="kr-summary-item">
                        <span class="kr-summary-icon-small">💼</span>
                        <div class="kr-summary-content">
                            <span class="kr-summary-label"><?php _e('Služby', 'kadernice-rezervace'); ?></span>
                            <span class="kr-summary-value" id="kr-summary-services"></span>
                        </div>
                    </div>
                    <div class="kr-summary-item">
                        <span class="kr-summary-icon-small">📅</span>
                        <div class="kr-summary-content">
                            <span class="kr-summary-label"><?php _e('Datum', 'kadernice-rezervace'); ?></span>
                            <span class="kr-summary-value" id="kr-summary-date"></span>
                        </div>
                    </div>
                    <div class="kr-summary-item">
                        <span class="kr-summary-icon-small">🕐</span>
                        <div class="kr-summary-content">
                            <span class="kr-summary-label"><?php _e('Čas', 'kadernice-rezervace'); ?></span>
                            <span class="kr-summary-value" id="kr-summary-time"></span>
                        </div>
                    </div>
                    <div class="kr-summary-item">
                        <span class="kr-summary-icon-small">⏱️</span>
                        <div class="kr-summary-content">
                            <span class="kr-summary-label"><?php _e('Doba trvání', 'kadernice-rezervace'); ?></span>
                            <span class="kr-summary-value" id="kr-summary-duration"></span>
                        </div>
                    </div>
                    <div class="kr-summary-item kr-summary-price-item">
                        <span class="kr-summary-icon-small">💰</span>
                        <div class="kr-summary-content">
                            <span class="kr-summary-label"><?php _e('Celková cena', 'kadernice-rezervace'); ?></span>
                            <span class="kr-summary-value kr-summary-price-value" id="kr-summary-price"></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Customer Details Form -->
            <form id="kr-booking-form" class="kr-form kr-form-modern">
                <div class="kr-form-section">
                    <h4 class="kr-form-section-title">
                        <span class="kr-section-icon">👤</span>
                        <?php _e('Kontaktní informace', 'kadernice-rezervace'); ?>
                    </h4>
                    
                    <div class="kr-form-row">
                        <div class="kr-form-group kr-form-group-large">
                            <label for="kr-customer-name">
                                <span class="kr-label-icon">✨</span>
                                <?php _e('Jméno a příjmení', 'kadernice-rezervace'); ?>
                                <span class="kr-required">*</span>
                            </label>
                            <div class="kr-input-wrapper">
                                <span class="kr-input-icon">👤</span>
                                <input type="text" id="kr-customer-name" name="customer_name" 
                                       placeholder="<?php esc_attr_e('Jan Novák', 'kadernice-rezervace'); ?>" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="kr-form-row kr-form-row-3col">
                        <div class="kr-form-group">
                            <label for="kr-customer-email">
                                <span class="kr-label-icon">📧</span>
                                <?php _e('Email', 'kadernice-rezervace'); ?>
                                <span class="kr-required">*</span>
                            </label>
                            <div class="kr-input-wrapper">
                                <span class="kr-input-icon">✉️</span>
                                <input type="email" id="kr-customer-email" name="customer_email" 
                                       placeholder="<?php esc_attr_e('jan.novak@email.cz', 'kadernice-rezervace'); ?>" required>
                            </div>
                        </div>
                        
                        <div class="kr-form-group">
                            <label for="kr-customer-phone">
                                <span class="kr-label-icon">📱</span>
                                <?php _e('Telefon', 'kadernice-rezervace'); ?>
                                <span class="kr-required">*</span>
                            </label>
                            <div class="kr-input-wrapper">
                                <span class="kr-input-icon">📞</span>
                                <input type="tel" id="kr-customer-phone" name="customer_phone" 
                                       placeholder="<?php esc_attr_e('+420 123 456 789', 'kadernice-rezervace'); ?>" required>
                            </div>
                        </div>
                        
                        <div class="kr-form-group">
                            <label for="kr-customer-initials">
                                <span class="kr-label-icon">✍️</span>
                                <?php _e('Iniciály', 'kadernice-rezervace'); ?>
                            </label>
                            <div class="kr-input-wrapper">
                                <span class="kr-input-icon">🔤</span>
                                <input type="text" id="kr-customer-initials" name="customer_initials" 
                                       maxlength="10"
                                       placeholder="<?php esc_attr_e('JN', 'kadernice-rezervace'); ?>">
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Notes Section -->
                <div class="kr-form-section">
                    <h4 class="kr-form-section-title">
                        <span class="kr-section-icon">📝</span>
                        <?php _e('Poznámka', 'kadernice-rezervace'); ?>
                        <span class="kr-badge-optional"><?php _e('Volitelné', 'kadernice-rezervace'); ?></span>
                    </h4>
                    
                    <div class="kr-form-group">
                        <label for="kr-notes">
                            <?php _e('Máte nějaké speciální požadavky nebo poznámky?', 'kadernice-rezervace'); ?>
                        </label>
                        <div class="kr-input-wrapper">
                            <textarea id="kr-notes" name="notes" rows="4" 
                                      placeholder="<?php esc_attr_e('Např. alergie, preference stylu, speciální požadavky...', 'kadernice-rezervace'); ?>"></textarea>
                        </div>
                    </div>
                </div>
                
                <input type="hidden" id="kr-service-ids" name="service_ids">
                <input type="hidden" id="kr-booking-date" name="booking_date">
                <input type="hidden" id="kr-booking-time" name="booking_time">
                
                <div class="kr-form-actions kr-form-actions-modern">
                    <button type="button" class="kr-btn kr-btn-secondary kr-btn-back">
                        <span class="kr-btn-icon">←</span>
                        <?php _e('Zpět', 'kadernice-rezervace'); ?>
                    </button>
                    <button type="submit" class="kr-btn kr-btn-primary kr-btn-submit">
                        <span class="kr-btn-icon">✓</span>
                        <?php _e('Potvrdit rezervaci', 'kadernice-rezervace'); ?>
                        <span class="kr-btn-arrow">→</span>
                    </button>
                </div>
            </form>
        </div>
        
        <!-- Success Message -->
        <div class="kr-step kr-step-success" data-step="5">
            <div class="kr-success-container">
                <div class="kr-success-icon">
                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <circle cx="12" cy="12" r="10"></circle>
                        <path d="M9 12l2 2 4-4"></path>
                    </svg>
                </div>
                <h3 class="kr-success-title"><?php _e('Rezervace úspěšná!', 'kadernice-rezervace'); ?></h3>
                <p class="kr-success-message"><?php _e('Vaše rezervace byla úspěšně odeslána. Na váš email jsme zaslali potvrzení s detaily rezervace.', 'kadernice-rezervace'); ?></p>
                
                <!-- Success Summary Box -->
                <div class="kr-success-summary">
                    <h4 class="kr-summary-heading"><?php _e('Shrnutí rezervace', 'kadernice-rezervace'); ?></h4>
                    <div class="kr-summary-grid">
                        <div class="kr-summary-item">
                            <span class="kr-summary-icon">📋</span>
                            <div class="kr-summary-content">
                                <span class="kr-summary-label"><?php _e('Služby', 'kadernice-rezervace'); ?></span>
                                <span class="kr-summary-value" id="kr-success-services"></span>
                            </div>
                        </div>
                        <div class="kr-summary-item">
                            <span class="kr-summary-icon">📅</span>
                            <div class="kr-summary-content">
                                <span class="kr-summary-label"><?php _e('Datum', 'kadernice-rezervace'); ?></span>
                                <span class="kr-summary-value" id="kr-success-date"></span>
                            </div>
                        </div>
                        <div class="kr-summary-item">
                            <span class="kr-summary-icon">⏰</span>
                            <div class="kr-summary-content">
                                <span class="kr-summary-label"><?php _e('Čas', 'kadernice-rezervace'); ?></span>
                                <span class="kr-summary-value" id="kr-success-time"></span>
                            </div>
                        </div>
                        <div class="kr-summary-item">
                            <span class="kr-summary-icon">⏱️</span>
                            <div class="kr-summary-content">
                                <span class="kr-summary-label"><?php _e('Doba trvání', 'kadernice-rezervace'); ?></span>
                                <span class="kr-summary-value" id="kr-success-duration"></span>
                            </div>
                        </div>
                        <div class="kr-summary-item">
                            <span class="kr-summary-icon">💰</span>
                            <div class="kr-summary-content">
                                <span class="kr-summary-label"><?php _e('Cena', 'kadernice-rezervace'); ?></span>
                                <span class="kr-summary-value" id="kr-success-price"></span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="kr-success-actions">
                    <button type="button" class="kr-btn kr-btn-primary kr-btn-new-booking">
                        <?php _e('✨ Nová rezervace', 'kadernice-rezervace'); ?>
                    </button>
                </div>
                
                <div class="kr-success-note">
                    <p><?php _e('💌 Zkontrolujte si prosím svou emailovou schránku (i spam) pro potvrzení rezervace.', 'kadernice-rezervace'); ?></p>
                </div>
            </div>
        </div>
        
        <!-- Progress Indicator -->
        <div class="kr-progress">
            <div class="kr-progress-step active" data-step="1">
                <span class="kr-progress-number">1</span>
                <span class="kr-progress-label"><?php _e('Služba', 'kadernice-rezervace'); ?></span>
            </div>
            <div class="kr-progress-step" data-step="2">
                <span class="kr-progress-number">2</span>
                <span class="kr-progress-label"><?php _e('Datum', 'kadernice-rezervace'); ?></span>
            </div>
            <div class="kr-progress-step" data-step="3">
                <span class="kr-progress-number">3</span>
                <span class="kr-progress-label"><?php _e('Čas', 'kadernice-rezervace'); ?></span>
            </div>
            <div class="kr-progress-step" data-step="4">
                <span class="kr-progress-number">4</span>
                <span class="kr-progress-label"><?php _e('Údaje', 'kadernice-rezervace'); ?></span>
            </div>
        </div>
        
    </div>
</div>