<?php
/**
 * Shortcode handler
 */

if (!defined('ABSPATH')) {
    exit;
}

class KR_Shortcode {
    
    public function __construct() {
        add_shortcode('kadernice_rezervace', array($this, 'render_booking_form'));
        add_shortcode('rezervace_box', array($this, 'render_booking_box'));
        add_shortcode('koupit_kadernice', array($this, 'render_shop_box'));
    }
    
    /**
     * Render booking form shortcode
     */
    public function render_booking_form($atts) {
        $atts = shortcode_atts(array(
            'service' => '',
            'theme' => 'default'
        ), $atts);
        
        ob_start();
        include KR_PLUGIN_DIR . 'templates/booking-form.php';
        return ob_get_clean();
    }
    
    /**
     * Render booking box with modal (similar to prodejni_box)
     * Usage: [rezervace_box nadpis="Rezervujte si termín" popis="Vyberte si službu a termín"]
     */
    public function render_booking_box($atts) {
        $atts = shortcode_atts(array(
            'nadpis' => __('Rezervace termínu', 'kadernice-rezervace'),
            'popis' => __('Vyberte si službu a termín online', 'kadernice-rezervace'),
            'button_text' => __('Rezervovat termín', 'kadernice-rezervace'),
            'theme' => 'default'
        ), $atts);
        
        $nadpis = esc_html($atts['nadpis']);
        $popis = esc_html($atts['popis']);
        $button_text = esc_html($atts['button_text']);
        
        ob_start();
        ?>
        <div class="kr-rezervace-box">
            <div class="kr-box-content">
                <h2 class="kr-box-nadpis"><?php echo $nadpis; ?></h2>
                <p class="kr-box-popis"><?php echo $popis; ?></p>
                <button class="kr-rezervovat-btn" onclick="krOtevritRezervaci()">
                    📅 <?php echo $button_text; ?>
                </button>
            </div>
        </div>
        
        <div id="kr-popup-overlay" class="kr-overlay" style="display:none;">
            <div class="kr-popup">
                <span class="kr-zavrit" onclick="krZavritRezervaci()">&times;</span>
                <div id="kr-formular-container">
                    <?php 
                    $form_atts = array('theme' => $atts['theme']);
                    include KR_PLUGIN_DIR . 'templates/booking-form.php'; 
                    ?>
                </div>
            </div>
        </div>
        
        <style>
        .kr-rezervace-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin: 20px 0;
        }
        
        .kr-box-content {
            max-width: 600px;
            margin: 0 auto;
        }
        
        .kr-box-nadpis {
            color: white;
            font-size: 32px;
            font-weight: 700;
            margin: 0 0 15px 0;
        }
        
        .kr-box-popis {
            color: rgba(255,255,255,0.9);
            font-size: 18px;
            margin: 0 0 30px 0;
        }
        
        .kr-rezervovat-btn {
            background: white;
            color: #667eea;
            border: none;
            padding: 15px 40px;
            font-size: 18px;
            font-weight: 600;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }
        
        .kr-rezervovat-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.3);
        }
        
        .kr-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 99999;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(5px);
        }
        
        .kr-popup {
            background: white;
            border-radius: 16px;
            max-width: 900px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            animation: krSlideIn 0.3s ease;
        }
        
        @keyframes krSlideIn {
            from {
                opacity: 0;
                transform: translateY(-50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .kr-zavrit {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 32px;
            color: #666;
            cursor: pointer;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: #f5f5f5;
            transition: all 0.2s ease;
            z-index: 10;
        }
        
        .kr-zavrit:hover {
            background: #e0e0e0;
            color: #333;
            transform: rotate(90deg);
        }
        
        #kr-formular-container {
            padding: 20px;
        }
        
        @media (max-width: 768px) {
            .kr-popup {
                width: 95%;
                max-height: 95vh;
            }
            
            .kr-box-nadpis {
                font-size: 24px;
            }
            
            .kr-box-popis {
                font-size: 16px;
            }
        }
        </style>
        
        <script>
        function krOtevritRezervaci() {
            document.getElementById('kr-popup-overlay').style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }
        
        function krZavritRezervaci() {
            document.getElementById('kr-popup-overlay').style.display = 'none';
            document.body.style.overflow = 'auto';
        }
        
        // Close on overlay click
        document.addEventListener('DOMContentLoaded', function() {
            const overlay = document.getElementById('kr-popup-overlay');
            if (overlay) {
                overlay.addEventListener('click', function(e) {
                    if (e.target === overlay) {
                        krZavritRezervaci();
                    }
                });
            }
        });
        
        // Close on ESC key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                krZavritRezervaci();
            }
        });
        </script>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Render shop box for selling Kadeřnice Rezervace plugin
     * Usage: [koupit_kadernice produkt="Kadeřnice Rezervace" cena="1500"]
     */
    public function render_shop_box($atts) {
        $atts = shortcode_atts(array(
            'produkt' => __('Kadeřnice Rezervace - Plugin', 'kadernice-rezervace'),
            'cena' => '1500',
            'popis' => __('Kompletní rezervační systém pro kadeřnictví', 'kadernice-rezervace'),
            'button_text' => __('🛒 Koupit nyní', 'kadernice-rezervace')
        ), $atts);
        
        $produkt = esc_html($atts['produkt']);
        $cena_number = floatval($atts['cena']);
        $cena = number_format($cena_number, 0, ',', ' ') . ' Kč';
        $popis = esc_html($atts['popis']);
        $button_text = esc_html($atts['button_text']);
        
        ob_start();
        ?>
        <div class="kr-shop-box">
            <div class="kr-shop-content">
                <div class="kr-shop-badge">🎉 Speciální nabídka</div>
                <h2 class="kr-shop-nadpis"><?php echo $produkt; ?></h2>
                <p class="kr-shop-popis"><?php echo $popis; ?></p>
                <div class="kr-shop-cena">
                    <span class="kr-cena-label">Cena:</span>
                    <span class="kr-cena-hodnota"><?php echo $cena; ?></span>
                </div>
                <button class="kr-koupit-btn" onclick="krOtevritProdej()">
                    <?php echo $button_text; ?>
                </button>
                
                <div class="kr-shop-benefits">
                    <h4>✅ Co získáte:</h4>
                    <ul>
                        <li>✓ Plnou verzi pluginu bez omezení</li>
                        <li>✓ Automatické aktualizace po dobu 1 roku</li>
                        <li>✓ Technickou podporu</li>
                        <li>✓ Přístup k dokumentaci</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div id="kr-shop-overlay" class="kr-shop-overlay" style="display:none;">
            <div class="kr-shop-popup">
                <span class="kr-shop-zavrit" onclick="krZavritProdej()">&times;</span>
                <div id="kr-shop-container">
                    <?php 
                    // Include payment form
                    $this->render_payment_form($produkt, $cena, $cena_number);
                    ?>
                </div>
            </div>
        </div>
        
        <style>
        .kr-shop-box {
            background: linear-gradient(135deg, #f89820 0%, #e08718 100%);
            border-radius: 16px;
            padding: 50px 40px;
            text-align: center;
            box-shadow: 0 15px 40px rgba(248, 152, 32, 0.3);
            margin: 30px 0;
            position: relative;
            overflow: hidden;
        }
        
        .kr-shop-box::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            animation: krShopGlow 4s ease-in-out infinite;
        }
        
        @keyframes krShopGlow {
            0%, 100% { transform: translate(0, 0); }
            50% { transform: translate(-20px, -20px); }
        }
        
        .kr-shop-content {
            position: relative;
            z-index: 1;
            max-width: 700px;
            margin: 0 auto;
        }
        
        .kr-shop-badge {
            display: inline-block;
            background: white;
            color: #f89820;
            padding: 8px 20px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            margin-bottom: 20px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }
        
        .kr-shop-nadpis {
            color: white;
            font-size: 38px;
            font-weight: 800;
            margin: 0 0 15px 0;
            text-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        
        .kr-shop-popis {
            color: rgba(255,255,255,0.95);
            font-size: 20px;
            margin: 0 0 30px 0;
        }
        
        .kr-shop-cena {
            background: rgba(255,255,255,0.2);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 20px;
            margin: 0 0 30px 0;
            border: 2px solid rgba(255,255,255,0.3);
        }
        
        .kr-cena-label {
            color: rgba(255,255,255,0.9);
            font-size: 16px;
            display: block;
            margin-bottom: 5px;
        }
        
        .kr-cena-hodnota {
            color: white;
            font-size: 48px;
            font-weight: 800;
            display: block;
            text-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        
        .kr-koupit-btn {
            background: white;
            color: #f89820;
            border: none;
            padding: 18px 50px;
            font-size: 20px;
            font-weight: 700;
            border-radius: 50px;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 6px 25px rgba(0,0,0,0.3);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .kr-koupit-btn:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 10px 35px rgba(0,0,0,0.4);
        }
        
        .kr-shop-benefits {
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(10px);
            border-radius: 12px;
            padding: 25px;
            margin-top: 30px;
            text-align: left;
        }
        
        .kr-shop-benefits h4 {
            color: white;
            font-size: 18px;
            margin: 0 0 15px 0;
            text-align: center;
        }
        
        .kr-shop-benefits ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        
        .kr-shop-benefits li {
            color: white;
            padding: 8px 0;
            font-size: 16px;
        }
        
        .kr-shop-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.8);
            z-index: 999999;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(5px);
        }
        
        .kr-shop-popup {
            background: white;
            border-radius: 20px;
            max-width: 700px;
            width: 90%;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            box-shadow: 0 25px 70px rgba(0,0,0,0.4);
            animation: krShopSlideIn 0.4s ease;
        }
        
        @keyframes krShopSlideIn {
            from {
                opacity: 0;
                transform: translateY(-100px) scale(0.9);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        .kr-shop-zavrit {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 36px;
            color: #666;
            cursor: pointer;
            width: 45px;
            height: 45px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            background: #f5f5f5;
            transition: all 0.2s ease;
            z-index: 10;
            font-weight: 300;
        }
        
        .kr-shop-zavrit:hover {
            background: #e0e0e0;
            color: #333;
            transform: rotate(90deg);
        }
        
        #kr-shop-container {
            padding: 30px;
        }
        
        @media (max-width: 768px) {
            .kr-shop-box {
                padding: 40px 25px;
            }
            
            .kr-shop-nadpis {
                font-size: 28px;
            }
            
            .kr-shop-popis {
                font-size: 16px;
            }
            
            .kr-cena-hodnota {
                font-size: 36px;
            }
            
            .kr-koupit-btn {
                font-size: 16px;
                padding: 15px 35px;
            }
            
            .kr-shop-popup {
                width: 95%;
            }
        }
        </style>
        
        <script>
        function krOtevritProdej() {
            document.getElementById('kr-shop-overlay').style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }
        
        function krZavritProdej() {
            document.getElementById('kr-shop-overlay').style.display = 'none';
            document.body.style.overflow = 'auto';
        }
        
        // Close on overlay click
        document.addEventListener('DOMContentLoaded', function() {
            const overlay = document.getElementById('kr-shop-overlay');
            if (overlay) {
                overlay.addEventListener('click', function(e) {
                    if (e.target === overlay) {
                        krZavritProdej();
                    }
                });
            }
        });
        
        // Close on ESC key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                krZavritProdej();
            }
        });
        </script>
        <?php
        return ob_get_clean();
    }
    
    /**
     * Render payment form (similar to rezervace-admin)
     */
    private function render_payment_form($produkt, $cena, $cena_number) {
        ?>
        <div class="kr-payment-form">
            <h2 style="text-align: center; color: #2d4a45; margin-bottom: 10px;">Objednávka: <?php echo esc_html($produkt); ?></h2>
            <p style="text-align: center; font-size: 24px; color: #f89820; font-weight: 700; margin-bottom: 30px;">
                Cena: <?php echo esc_html($cena); ?>
            </p>
            
            <form id="kr-payment-form" style="max-width: 500px; margin: 0 auto;">
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #333;">Jméno a příjmení *</label>
                    <input type="text" name="name" required placeholder="Jan Novák" 
                           style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px; font-size: 16px;">
                </div>
                
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #333;">Email *</label>
                    <input type="email" name="email" required placeholder="jan@example.com"
                           style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px; font-size: 16px;">
                </div>
                
                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600; color: #333;">Telefon</label>
                    <input type="tel" name="phone" placeholder="+420 123 456 789"
                           style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px; font-size: 16px;">
                </div>
                
                <div style="margin-bottom: 25px;">
                    <label style="display: flex; align-items: center; cursor: pointer;">
                        <input type="checkbox" name="gdpr" required style="margin-right: 10px; width: 18px; height: 18px;">
                        <span style="font-size: 14px; color: #666;">
                            Souhlasím se <a href="/ochrana-osobnich-udaju" target="_blank" style="color: #f89820;">zpracováním osobních údajů</a> *
                        </span>
                    </label>
                </div>
                
                <input type="hidden" name="product_name" value="<?php echo esc_attr($produkt); ?>">
                <input type="hidden" name="price" value="<?php echo esc_attr($cena_number); ?>">
                
                <button type="submit" style="width: 100%; background: linear-gradient(135deg, #f89820 0%, #e08718 100%); color: white; border: none; padding: 16px; font-size: 18px; font-weight: 700; border-radius: 50px; cursor: pointer; box-shadow: 0 4px 15px rgba(248, 152, 32, 0.4); transition: all 0.3s ease;">
                    🛒 Objednat a zaplatit
                </button>
                
                <div id="kr-payment-message" style="margin-top: 20px; padding: 15px; border-radius: 8px; display: none;"></div>
            </form>
            
            <div style="background: #f0f7ff; padding: 25px; border-radius: 12px; margin-top: 30px;">
                <h3 style="margin: 0 0 15px 0; color: #2d4a45; font-size: 18px;">✅ Co získáte:</h3>
                <ul style="margin: 0; padding-left: 20px; color: #666;">
                    <li style="margin-bottom: 8px;">✓ Plnou verzi pluginu bez omezení</li>
                    <li style="margin-bottom: 8px;">✓ Automatické aktualizace po dobu 1 roku</li>
                    <li style="margin-bottom: 8px;">✓ Technickou podporu</li>
                    <li style="margin-bottom: 8px;">✓ Přístup k dokumentaci</li>
                </ul>
            </div>
            
            <div style="background: #fff3cd; padding: 15px; border-radius: 8px; margin-top: 20px; border-left: 4px solid #ffc107;">
                <p style="margin: 0; font-size: 14px; color: #856404;">
                    <strong>💡 Tip:</strong> Po vyplnění formuláře obdržíte platební instrukce na email.
                </p>
            </div>
        </div>
        
        <script>
        jQuery(document).ready(function($) {
            $('#kr-payment-form').on('submit', function(e) {
                e.preventDefault();
                
                const form = $(this);
                const submitBtn = form.find('button[type="submit"]');
                const messageDiv = $('#kr-payment-message');
                
                // Disable button
                submitBtn.prop('disabled', true).text('Odesílání...');
                
                $.ajax({
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    type: 'POST',
                    data: form.serialize() + '&action=ra_process_payment&nonce=<?php echo wp_create_nonce('ra-ajax-nonce'); ?>',
                    success: function(response) {
                        if (response.success) {
                            messageDiv.css({
                                'display': 'block',
                                'background': '#d4edda',
                                'color': '#155724',
                                'border': '1px solid #c3e6cb'
                            }).html('✅ ' + response.data.message);
                            
                            form[0].reset();
                            
                            // Close modal after 3 seconds
                            setTimeout(function() {
                                krZavritProdej();
                                messageDiv.hide();
                            }, 3000);
                        } else {
                            messageDiv.css({
                                'display': 'block',
                                'background': '#f8d7da',
                                'color': '#721c24',
                                'border': '1px solid #f5c6cb'
                            }).html('❌ ' + response.data.message);
                        }
                        
                        submitBtn.prop('disabled', false).html('🛒 Objednat a zaplatit');
                    },
                    error: function() {
                        messageDiv.css({
                            'display': 'block',
                            'background': '#f8d7da',
                            'color': '#721c24',
                            'border': '1px solid #f5c6cb'
                        }).html('❌ Chyba při odesílání. Zkuste to prosím znovu.');
                        
                        submitBtn.prop('disabled', false).html('🛒 Objednat a zaplatit');
                    }
                });
            });
        });
        </script>
        <?php
    }
}