<?php
/**
 * Services management
 */

if (!defined('ABSPATH')) {
    exit;
}

class KR_Services {
    
    /**
     * Get all active services
     */
    public static function get_active_services() {
        return KR_Database::get_services(true);
    }
    
    /**
     * Get service details
     */
    public static function get_service($id) {
        return KR_Database::get_service($id);
    }
    
    /**
     * Format price
     */
    public static function format_price($price) {
        $currency = get_option('kr_currency', 'Kč');
        return number_format($price, 0, ',', ' ') . ' ' . $currency;
    }
    
    /**
     * Format duration
     */
    public static function format_duration($minutes) {
        if ($minutes < 60) {
            return $minutes . ' min';
        }
        
        $hours = floor($minutes / 60);
        $mins = $minutes % 60;
        
        if ($mins == 0) {
            return $hours . ' h';
        }
        
        return $hours . ' h ' . $mins . ' min';
    }
}