<?php
/**
 * Gutenberg block handler
 */

if (!defined('ABSPATH')) {
    exit;
}

class KR_Gutenberg {
    
    public function __construct() {
        add_action('init', array($this, 'register_block'));
    }
    
    /**
     * Register Gutenberg block
     */
    public function register_block() {
        if (!function_exists('register_block_type')) {
            return;
        }
        
        wp_register_script(
            'kr-gutenberg-block',
            KR_PLUGIN_URL . 'assets/js/gutenberg-block.js',
            array('wp-blocks', 'wp-element', 'wp-editor', 'wp-components'),
            KR_VERSION
        );
        
        register_block_type('kadernice-rezervace/booking-form', array(
            'editor_script' => 'kr-gutenberg-block',
            'render_callback' => array($this, 'render_block'),
            'attributes' => array(
                'service' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'theme' => array(
                    'type' => 'string',
                    'default' => 'default'
                )
            )
        ));
    }
    
    /**
     * Render block
     */
    public function render_block($attributes) {
        ob_start();
        include KR_PLUGIN_DIR . 'templates/booking-form.php';
        return ob_get_clean();
    }
}