<?php
/**
 * Admin interface
 */

if (!defined('ABSPATH')) {
    exit;
}

class KR_Admin {
    
    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_init', array($this, 'register_settings'));
    }
    
    /**
     * Add admin menu
     */
    public function add_admin_menu() {
        add_menu_page(
            __('Kadeřnice Rezervace', 'kadernice-rezervace'),
            __('Rezervace', 'kadernice-rezervace'),
            'manage_options',
            'kadernice-rezervace',
            array($this, 'render_welcome_page'),
            'dashicons-calendar-alt',
            30
        );
        
        add_submenu_page(
            'kadernice-rezervace',
            __('Úvodní stránka', 'kadernice-rezervace'),
            __('Úvodní stránka', 'kadernice-rezervace'),
            'manage_options',
            'kadernice-rezervace',
            array($this, 'render_welcome_page')
        );
        
        add_submenu_page(
            'kadernice-rezervace',
            __('Rezervace v kadeřnictví', 'kadernice-rezervace'),
            __('Rezervace v kadeřnictví', 'kadernice-rezervace'),
            'manage_options',
            'kr-bookings',
            array($this, 'render_bookings_page')
        );
        
        add_submenu_page(
            'kadernice-rezervace',
            __('Služby', 'kadernice-rezervace'),
            __('Služby', 'kadernice-rezervace'),
            'manage_options',
            'kr-services',
            array($this, 'render_services_page')
        );
        
        add_submenu_page(
            'kadernice-rezervace',
            __('Pracovní doba', 'kadernice-rezervace'),
            __('Pracovní doba', 'kadernice-rezervace'),
            'manage_options',
            'kr-working-hours',
            array($this, 'render_working_hours_page')
        );
        
        add_submenu_page(
            'kadernice-rezervace',
            __('Nastavení', 'kadernice-rezervace'),
            __('Nastavení', 'kadernice-rezervace'),
            'manage_options',
            'kr-settings',
            array($this, 'render_settings_page')
        );
    }
    
    /**
     * Register settings
     */
    public function register_settings() {
        register_setting('kr_settings', 'kr_business_name');
        register_setting('kr_settings', 'kr_business_email');
        register_setting('kr_settings', 'kr_business_phone');
        register_setting('kr_settings', 'kr_booking_interval');
        register_setting('kr_settings', 'kr_advance_booking_days');
        register_setting('kr_settings', 'kr_min_booking_notice');
        register_setting('kr_settings', 'kr_enable_email_notifications');
        register_setting('kr_settings', 'kr_admin_email_on_booking');
        register_setting('kr_settings', 'kr_customer_email_on_booking');
        register_setting('kr_settings', 'kr_currency');
        register_setting('kr_settings', 'kr_date_format');
        register_setting('kr_settings', 'kr_time_format');
        register_setting('kr_settings', 'kr_payment_enabled');
        register_setting('kr_settings', 'kr_payment_provider');
        register_setting('kr_settings', 'kr_payment_api_key');
        register_setting('kr_settings', 'kr_payment_api_secret');
    }
    
    /**
     * Render welcome page
     */
    public function render_welcome_page() {
        include KR_PLUGIN_DIR . 'admin/pages/welcome.php';
    }
    
    /**
     * Render bookings page
     */
    public function render_bookings_page() {
        include KR_PLUGIN_DIR . 'admin/pages/bookings.php';
    }
    
    /**
     * Render services page
     */
    public function render_services_page() {
        include KR_PLUGIN_DIR . 'admin/pages/services.php';
    }
    
    /**
     * Render working hours page
     */
    public function render_working_hours_page() {
        include KR_PLUGIN_DIR . 'admin/pages/working-hours.php';
    }
    
    /**
     * Render settings page
     */
    public function render_settings_page() {
        include KR_PLUGIN_DIR . 'admin/pages/settings.php';
    }
}