/**
 * Gutenberg Block for Kadeřnice Rezervace
 */

(function(blocks, element, components) {
    const el = element.createElement;
    const { registerBlockType } = blocks;
    const { InspectorControls } = wp.editor || wp.blockEditor;
    const { PanelBody, SelectControl } = components;
    
    registerBlockType('kadernice-rezervace/booking-form', {
        title: 'Kadeřnice Rezervace',
        description: 'Rezervační formulář pro kadeřnictví',
        icon: 'calendar-alt',
        category: 'widgets',
        attributes: {
            service: {
                type: 'string',
                default: ''
            },
            theme: {
                type: 'string',
                default: 'default'
            }
        },
        
        edit: function(props) {
            const { attributes, setAttributes } = props;
            
            return el('div', { className: props.className },
                el(InspectorControls, {},
                    el(PanelBody, { title: 'Nastavení', initialOpen: true },
                        el(SelectControl, {
                            label: 'Téma',
                            value: attributes.theme,
                            options: [
                                { label: 'Výchozí', value: 'default' },
                                { label: 'Světlé', value: 'light' },
                                { label: 'Tmavé', value: 'dark' }
                            ],
                            onChange: function(value) {
                                setAttributes({ theme: value });
                            }
                        })
                    )
                ),
                el('div', {
                    style: {
                        padding: '40px',
                        background: '#f9fafb',
                        border: '2px dashed #e5e7eb',
                        borderRadius: '8px',
                        textAlign: 'center'
                    }
                },
                    el('span', {
                        className: 'dashicons dashicons-calendar-alt',
                        style: { fontSize: '48px', color: '#f89820', marginBottom: '16px' }
                    }),
                    el('h3', { style: { margin: '16px 0 8px' } }, 'Kadeřnice Rezervace'),
                    el('p', { style: { color: '#6b7280', margin: 0 } }, 
                        'Rezervační formulář se zobrazí na frontendu'
                    )
                )
            );
        },
        
        save: function() {
            return null; // Rendered via PHP
        }
    });
    
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components
);