/**
 * Admin JavaScript for Kadeřnice Rezervace
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // Update booking status
        $('.kr-status-select').on('change', function() {
            const bookingId = $(this).data('booking-id');
            const status = $(this).val();
            const $select = $(this);
            
            if (!confirm('Opravdu chcete změnit status této rezervace?')) {
                return;
            }
            
            $.ajax({
                url: krAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'kr_update_booking_status',
                    nonce: krAdmin.nonce,
                    booking_id: bookingId,
                    status: status
                },
                success: function(response) {
                    if (response.success) {
                        alert('Status byl aktualizován');
                    } else {
                        alert(response.data.message || 'Chyba při aktualizaci statusu');
                        $select.val($select.data('original-value'));
                    }
                },
                error: function() {
                    alert('Chyba při aktualizaci statusu');
                    $select.val($select.data('original-value'));
                }
            });
        });
        
        // Store original value
        $('.kr-status-select').each(function() {
            $(this).data('original-value', $(this).val());
        });
        
        // Delete booking
        $('.kr-delete-booking').on('click', function() {
            const bookingId = $(this).data('booking-id');
            const $row = $(this).closest('tr');
            
            if (!confirm('Opravdu chcete smazat tuto rezervaci? Tato akce je nevratná.')) {
                return;
            }
            
            $.ajax({
                url: krAdmin.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'kr_delete_booking',
                    nonce: krAdmin.nonce,
                    booking_id: bookingId
                },
                success: function(response) {
                    if (response.success) {
                        $row.fadeOut(300, function() {
                            $(this).remove();
                        });
                    } else {
                        alert(response.data.message || 'Chyba při mazání rezervace');
                    }
                },
                error: function() {
                    alert('Chyba při mazání rezervace');
                }
            });
        });
        
        // View booking details
        $('.kr-view-booking').on('click', function() {
            const bookingId = $(this).data('booking-id');
            // TODO: Implement booking details modal
            alert('Detail rezervace #' + bookingId);
        });
        
    });
    
})(jQuery);