<?php
/**
 * Admin working hours page
 */

if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;

$days = array(
    1 => __('Pondělí', 'kadernice-rezervace'),
    2 => __('Úterý', 'kadernice-rezervace'),
    3 => __('Středa', 'kadernice-rezervace'),
    4 => __('Čtvrtek', 'kadernice-rezervace'),
    5 => __('Pátek', 'kadernice-rezervace'),
    6 => __('Sobota', 'kadernice-rezervace'),
    7 => __('Neděle', 'kadernice-rezervace')
);

// Handle working hours save
if (isset($_POST['kr_save_working_hours']) && check_admin_referer('kr_working_hours_nonce')) {
    $table = $wpdb->prefix . 'kr_time_slots';
    
    foreach ($days as $day_num => $day_name) {
        // Delete existing slots for this day
        $wpdb->delete($table, array('day_of_week' => $day_num));
        
        // Add new slot if active
        if (isset($_POST['working_hours'][$day_num]['active'])) {
            $start_time = sanitize_text_field($_POST['working_hours'][$day_num]['start']) . ':00';
            $end_time = sanitize_text_field($_POST['working_hours'][$day_num]['end']) . ':00';
            
            $wpdb->insert($table, array(
                'day_of_week' => $day_num,
                'start_time' => $start_time,
                'end_time' => $end_time,
                'is_active' => 1
            ));
        }
    }
    
    echo '<div class="notice notice-success"><p>' . __('Pracovní doba byla uložena.', 'kadernice-rezervace') . '</p></div>';
}

// Handle block date
if (isset($_POST['kr_block_date']) && check_admin_referer('kr_block_date_nonce')) {
    $table = $wpdb->prefix . 'kr_blocked_dates';
    $blocked_date = sanitize_text_field($_POST['blocked_date']);
    $reason = sanitize_text_field($_POST['block_reason']);
    
    $result = $wpdb->insert($table, array(
        'blocked_date' => $blocked_date,
        'reason' => $reason
    ));
    
    if ($result) {
        echo '<div class="notice notice-success"><p>' . __('Datum bylo zablokováno.', 'kadernice-rezervace') . '</p></div>';
    } else {
        echo '<div class="notice notice-error"><p>' . __('Toto datum je již zablokováno.', 'kadernice-rezervace') . '</p></div>';
    }
}

// Handle unblock date
if (isset($_GET['action']) && $_GET['action'] === 'unblock' && isset($_GET['date_id']) && check_admin_referer('kr_unblock_date_' . $_GET['date_id'])) {
    $table = $wpdb->prefix . 'kr_blocked_dates';
    $date_id = intval($_GET['date_id']);
    
    $wpdb->delete($table, array('id' => $date_id));
    echo '<div class="notice notice-success"><p>' . __('Datum bylo odblokováno.', 'kadernice-rezervace') . '</p></div>';
}

// Get current working hours
$working_hours = array();
foreach ($days as $day_num => $day_name) {
    $slots = KR_Database::get_time_slots($day_num);
    $working_hours[$day_num] = !empty($slots) ? $slots[0] : null;
}
?>

<div class="wrap">
    <h1><?php _e('Pracovní doba', 'kadernice-rezervace'); ?></h1>
    
    <div class="kr-working-hours-table">
        <form method="post" action="">
            <?php wp_nonce_field('kr_working_hours_nonce'); ?>
            
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th style="width: 150px;"><?php _e('Den', 'kadernice-rezervace'); ?></th>
                        <th style="width: 100px;"><?php _e('Otevřeno', 'kadernice-rezervace'); ?></th>
                        <th style="width: 150px;"><?php _e('Od', 'kadernice-rezervace'); ?></th>
                        <th style="width: 150px;"><?php _e('Do', 'kadernice-rezervace'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($days as $day_num => $day_name): ?>
                        <?php $slot = $working_hours[$day_num]; ?>
                        <tr>
                            <td><strong><?php echo esc_html($day_name); ?></strong></td>
                            <td>
                                <input type="checkbox" 
                                       name="working_hours[<?php echo $day_num; ?>][active]" 
                                       value="1"
                                       class="kr-day-active"
                                       data-day="<?php echo $day_num; ?>"
                                       <?php checked($slot && $slot->is_active, 1); ?>>
                            </td>
                            <td>
                                <input type="time" 
                                       name="working_hours[<?php echo $day_num; ?>][start]" 
                                       class="kr-time-input"
                                       data-day="<?php echo $day_num; ?>"
                                       value="<?php echo $slot ? esc_attr(substr($slot->start_time, 0, 5)) : '09:00'; ?>"
                                       <?php echo !$slot || !$slot->is_active ? 'disabled' : ''; ?>>
                            </td>
                            <td>
                                <input type="time" 
                                       name="working_hours[<?php echo $day_num; ?>][end]" 
                                       class="kr-time-input"
                                       data-day="<?php echo $day_num; ?>"
                                       value="<?php echo $slot ? esc_attr(substr($slot->end_time, 0, 5)) : '17:00'; ?>"
                                       <?php echo !$slot || !$slot->is_active ? 'disabled' : ''; ?>>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <p class="submit">
                <button type="submit" name="kr_save_working_hours" class="button button-primary">
                    <?php _e('Uložit pracovní dobu', 'kadernice-rezervace'); ?>
                </button>
            </p>
        </form>
    </div>
    
    <hr style="margin: 40px 0;">
    
    <h2><?php _e('Blokovaná data', 'kadernice-rezervace'); ?></h2>
    
    <form method="post" action="" style="margin-bottom: 20px; background: #fff; padding: 20px; border: 1px solid #ccd0d4; border-radius: 4px; max-width: 600px;">
        <?php wp_nonce_field('kr_block_date_nonce'); ?>
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="blocked_date"><?php _e('Datum', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="date" id="blocked_date" name="blocked_date" required min="<?php echo date('Y-m-d'); ?>">
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="block_reason"><?php _e('Důvod (volitelný)', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="block_reason" name="block_reason" class="regular-text" 
                           placeholder="<?php esc_attr_e('Např.: Dovolená, Svátek', 'kadernice-rezervace'); ?>">
                </td>
            </tr>
        </table>
        <p class="submit" style="margin: 0; padding: 0;">
            <button type="submit" name="kr_block_date" class="button button-primary">
                <?php _e('Blokovat datum', 'kadernice-rezervace'); ?>
            </button>
        </p>
    </form>
    
    <div class="kr-blocked-dates-list">
        <?php
        $blocked_dates = KR_Database::get_blocked_dates(date('Y-m-d'));
        
        if (empty($blocked_dates)): ?>
            <p><?php _e('Žádná blokovaná data.', 'kadernice-rezervace'); ?></p>
        <?php else: ?>
            <?php foreach ($blocked_dates as $blocked): ?>
                <div class="kr-blocked-date-item">
                    <div class="kr-blocked-date-info">
                        <div class="kr-blocked-date-date">
                            <strong><?php echo date_i18n('d.m.Y', strtotime($blocked->blocked_date)); ?></strong>
                            <span style="color: #646970; margin-left: 8px;">
                                (<?php echo date_i18n('l', strtotime($blocked->blocked_date)); ?>)
                            </span>
                        </div>
                        <?php if ($blocked->reason): ?>
                            <div class="kr-blocked-date-reason">
                                <?php echo esc_html($blocked->reason); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <a href="<?php echo wp_nonce_url(admin_url('admin.php?page=kr-working-hours&action=unblock&date_id=' . $blocked->id), 'kr_unblock_date_' . $blocked->id); ?>" 
                       class="button button-small button-link-delete"
                       onclick="return confirm('<?php esc_attr_e('Opravdu chcete odblokovat toto datum?', 'kadernice-rezervace'); ?>');">
                        <?php _e('Odblokovat', 'kadernice-rezervace'); ?>
                    </a>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Enable/disable time inputs based on checkbox
    $('.kr-day-active').on('change', function() {
        const day = $(this).data('day');
        const isChecked = $(this).is(':checked');
        
        $('input[data-day="' + day + '"].kr-time-input').prop('disabled', !isChecked);
    });
});
</script>

<style>
.kr-working-hours-table {
    margin-top: 20px;
}

.kr-working-hours-table table {
    max-width: 800px;
}

.kr-working-hours-table input[type="time"] {
    padding: 6px 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

.kr-working-hours-table input[type="time"]:disabled {
    background: #f0f0f1;
    color: #a0a5aa;
}

.kr-blocked-dates-list {
    margin-top: 20px;
}

.kr-blocked-date-item {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 16px;
    margin-bottom: 12px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.kr-blocked-date-info {
    flex: 1;
}

.kr-blocked-date-date {
    font-size: 15px;
    margin-bottom: 4px;
}

.kr-blocked-date-reason {
    font-size: 14px;
    color: #646970;
}
</style>