<?php
/**
 * Admin welcome/dashboard page
 */

if (!defined('ABSPATH')) {
    exit;
}

// Handle create page action
if (isset($_POST['kr_create_page']) && check_admin_referer('kr_create_page_nonce')) {
    $page_data = array(
        'post_title' => __('Rezervace', 'kadernice-rezervace'),
        'post_content' => '[kadernice_rezervace]',
        'post_status' => 'publish',
        'post_type' => 'page',
        'post_author' => get_current_user_id(),
        'comment_status' => 'closed',
        'ping_status' => 'closed'
    );
    
    $page_id = wp_insert_post($page_data);
    
    if ($page_id) {
        update_option('kr_booking_page_id', $page_id);
        echo '<div class="notice notice-success"><p>' . __('Stránka byla úspěšně vytvořena!', 'kadernice-rezervace') . '</p></div>';
    }
}

$booking_page_id = get_option('kr_booking_page_id');
$booking_page = $booking_page_id ? get_post($booking_page_id) : null;

// Get statistics
global $wpdb;
$stats = array(
    'total_bookings' => $wpdb->get_var("SELECT COUNT(*) FROM " . $wpdb->prefix . "kr_bookings"),
    'pending_bookings' => $wpdb->get_var("SELECT COUNT(*) FROM " . $wpdb->prefix . "kr_bookings WHERE status = 'pending'"),
    'total_services' => $wpdb->get_var("SELECT COUNT(*) FROM " . $wpdb->prefix . "kr_services WHERE is_active = 1"),
    'today_bookings' => $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM " . $wpdb->prefix . "kr_bookings WHERE booking_date = %s",
        date('Y-m-d')
    ))
);
?>

<div class="wrap kr-welcome-page">
    <style>
        .kr-welcome-page {
            margin: 20px 20px 20px 0;
        }
        .kr-welcome-header {
            background: linear-gradient(135deg, #f89820 0%, #e08718 100%);
            color: white;
            padding: 40px;
            border-radius: 8px;
            margin-bottom: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        .kr-welcome-header h1 {
            color: white;
            font-size: 36px;
            margin: 0 0 12px;
            font-weight: 700;
        }
        .kr-welcome-header p {
            font-size: 16px;
            margin: 0;
            opacity: 0.95;
        }
        .kr-stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .kr-stat-card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 24px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            transition: all 0.3s;
        }
        .kr-stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .kr-stat-number {
            font-size: 36px;
            font-weight: 700;
            color: #f89820;
            margin-bottom: 8px;
        }
        .kr-stat-label {
            font-size: 14px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .kr-quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .kr-action-card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 28px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        .kr-action-card h3 {
            margin-top: 0;
            font-size: 20px;
            color: #2d4a45;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .kr-action-card .dashicons {
            color: #f89820;
            font-size: 28px;
            width: 28px;
            height: 28px;
        }
        .kr-shortcode-box {
            background: #f9fafb;
            border: 2px dashed #e5e7eb;
            border-radius: 6px;
            padding: 20px;
            margin: 20px 0;
            position: relative;
        }
        .kr-shortcode-code {
            font-family: 'Courier New', monospace;
            font-size: 16px;
            color: #2d4a45;
            font-weight: 600;
            text-align: center;
            user-select: all;
        }
        .kr-copy-button {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #f89820;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 13px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .kr-copy-button:hover {
            background: #e08718;
        }
        .kr-copy-button.copied {
            background: #22c55e;
        }
        .kr-btn-primary {
            background: #f89820;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 6px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s;
        }
        .kr-btn-primary:hover {
            background: #e08718;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(248, 152, 32, 0.3);
        }
        .kr-btn-secondary {
            background: white;
            color: #2d4a45;
            border: 2px solid #2d4a45;
            padding: 10px 22px;
            border-radius: 6px;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s;
            margin-left: 12px;
        }
        .kr-btn-secondary:hover {
            background: #2d4a45;
            color: white;
        }
        .kr-success-message {
            background: #d1fae5;
            border: 1px solid #22c55e;
            border-radius: 6px;
            padding: 16px;
            margin: 20px 0;
            color: #065f46;
        }
        .kr-success-message .dashicons {
            color: #22c55e;
            margin-right: 8px;
        }
        .kr-help-section {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 28px;
            margin-bottom: 30px;
        }
    </style>
    
    <div class="kr-welcome-header">
        <h1><?php _e('Vítejte v Kadeřnice Rezervace! 💇‍♀️', 'kadernice-rezervace'); ?></h1>
        <p><?php _e('Kompletní přehled a rychlý start s rezervačním systémem', 'kadernice-rezervace'); ?></p>
    </div>
    
    <!-- Statistics -->
    <div class="kr-stats-grid">
        <div class="kr-stat-card">
            <div class="kr-stat-number"><?php echo esc_html($stats['total_bookings']); ?></div>
            <div class="kr-stat-label"><?php _e('Celkem rezervací', 'kadernice-rezervace'); ?></div>
        </div>
        <div class="kr-stat-card">
            <div class="kr-stat-number"><?php echo esc_html($stats['pending_bookings']); ?></div>
            <div class="kr-stat-label"><?php _e('Čekající rezervace', 'kadernice-rezervace'); ?></div>
        </div>
        <div class="kr-stat-card">
            <div class="kr-stat-number"><?php echo esc_html($stats['total_services']); ?></div>
            <div class="kr-stat-label"><?php _e('Aktivní služby', 'kadernice-rezervace'); ?></div>
        </div>
        <div class="kr-stat-card">
            <div class="kr-stat-number"><?php echo esc_html($stats['today_bookings']); ?></div>
            <div class="kr-stat-label"><?php _e('Dnes rezervací', 'kadernice-rezervace'); ?></div>
        </div>
    </div>
    
    <!-- Quick Actions -->
    <div class="kr-quick-actions">
        <!-- Create Page -->
        <div class="kr-action-card">
            <h3>
                <span class="dashicons dashicons-calendar-alt"></span>
                <?php _e('Rezervační stránka', 'kadernice-rezervace'); ?>
            </h3>
            
            <?php if ($booking_page): ?>
                <div class="kr-success-message">
                    <span class="dashicons dashicons-yes-alt"></span>
                    <strong><?php _e('Stránka vytvořena!', 'kadernice-rezervace'); ?></strong>
                    <p style="margin: 8px 0 0;">
                        <?php printf(
                            __('Stránka "%s" je připravena.', 'kadernice-rezervace'),
                            esc_html($booking_page->post_title)
                        ); ?>
                    </p>
                </div>
                
                <div style="margin-top: 16px;">
                    <a href="<?php echo get_permalink($booking_page_id); ?>" class="kr-btn-primary" target="_blank">
                        <?php _e('Zobrazit stránku', 'kadernice-rezervace'); ?>
                    </a>
                    <a href="<?php echo admin_url('post.php?post=' . $booking_page_id . '&action=edit'); ?>" class="kr-btn-secondary">
                        <?php _e('Upravit', 'kadernice-rezervace'); ?>
                    </a>
                </div>
            <?php else: ?>
                <p><?php _e('Vytvořte novou stránku s rezervačním formulářem jedním kliknutím.', 'kadernice-rezervace'); ?></p>
                
                <form method="post" action="" style="margin-top: 16px;">
                    <?php wp_nonce_field('kr_create_page_nonce'); ?>
                    <button type="submit" name="kr_create_page" class="kr-btn-primary">
                        <?php _e('Vytvořit stránku', 'kadernice-rezervace'); ?>
                    </button>
                </form>
            <?php endif; ?>
        </div>
        
        <!-- Shortcode -->
        <div class="kr-action-card">
            <h3>
                <span class="dashicons dashicons-editor-code"></span>
                <?php _e('Shortcode', 'kadernice-rezervace'); ?>
            </h3>
            
            <p><?php _e('Zkopírujte a vložte tento kód na libovolnou stránku:', 'kadernice-rezervace'); ?></p>
            
            <div class="kr-shortcode-box">
                <button type="button" class="kr-copy-button" onclick="krCopyShortcode(this)">
                    <?php _e('Zkopírovat', 'kadernice-rezervace'); ?>
                </button>
                <div class="kr-shortcode-code">[kadernice_rezervace]</div>
            </div>
            
            <p style="margin-top: 16px; font-size: 13px; color: #666;">
                <?php _e('Nebo použijte Gutenberg blok "Kadeřnice Rezervace"', 'kadernice-rezervace'); ?>
            </p>
        </div>
    </div>
    
    <!-- Quick Links -->
    <div class="kr-help-section">
        <h2><?php _e('Rychlé odkazy', 'kadernice-rezervace'); ?></h2>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 16px; margin-top: 20px;">
            <a href="<?php echo admin_url('admin.php?page=kr-bookings'); ?>" class="kr-btn-secondary" style="text-align: center; margin: 0;">
                <?php _e('📅 Rezervace v kadeřnictví', 'kadernice-rezervace'); ?>
            </a>
            <a href="<?php echo admin_url('admin.php?page=kr-services'); ?>" class="kr-btn-secondary" style="text-align: center; margin: 0;">
                <?php _e('✂️ Spravovat služby', 'kadernice-rezervace'); ?>
            </a>
            <a href="<?php echo admin_url('admin.php?page=kr-working-hours'); ?>" class="kr-btn-secondary" style="text-align: center; margin: 0;">
                <?php _e('⏰ Pracovní doba', 'kadernice-rezervace'); ?>
            </a>
            <a href="<?php echo admin_url('admin.php?page=kr-settings'); ?>" class="kr-btn-secondary" style="text-align: center; margin: 0;">
                <?php _e('⚙️ Nastavení', 'kadernice-rezervace'); ?>
            </a>
        </div>
    </div>
    
    <script>
    function krCopyShortcode(button) {
        const shortcode = '[kadernice_rezervace]';
        
        navigator.clipboard.writeText(shortcode).then(function() {
            const originalText = button.textContent;
            button.textContent = '<?php esc_js(_e('Zkopírováno!', 'kadernice-rezervace')); ?>';
            button.classList.add('copied');
            
            setTimeout(function() {
                button.textContent = originalText;
                button.classList.remove('copied');
            }, 2000);
        }).catch(function(err) {
            alert('<?php esc_js(_e('Chyba při kopírování', 'kadernice-rezervace')); ?>');
        });
    }
    </script>
</div>