<?php
/**
 * Shop settings page
 */

if (!defined('ABSPATH')) exit;

$price = get_option('kr_shop_price', 1290);
$bank_account = get_option('kr_shop_bank_account', '');
$variable_symbol = get_option('kr_shop_variable_symbol', '');
$iban = get_option('kr_shop_iban', '');
$swift = get_option('kr_shop_swift', '');
$enable_qr = get_option('kr_shop_enable_qr', 1);
$qr_image_url = get_option('kr_shop_qr_image', '');
?>

<div class="wrap">
    <h1>⚙️ Nastavení prodeje</h1>
    
    <form method="post" action="">
        <?php wp_nonce_field('kr_shop_settings'); ?>
        
        <table class="form-table">
            <tr>
                <th colspan="2">
                    <h2 style="margin-top: 0;">💰 Cena pluginu</h2>
                </th>
            </tr>
            <tr>
                <th scope="row">
                    <label for="shop_price">Cena (Kč)</label>
                </th>
                <td>
                    <input type="number" id="shop_price" name="shop_price" 
                           value="<?php echo esc_attr($price); ?>" 
                           class="regular-text" step="0.01" min="0">
                    <p class="description">Prodejní cena pluginu v Kč</p>
                </td>
            </tr>
            
            <tr>
                <th colspan="2">
                    <h2>🏦 Bankovní údaje</h2>
                </th>
            </tr>
            <tr>
                <th scope="row">
                    <label for="shop_bank_account">Číslo účtu *</label>
                </th>
                <td>
                    <input type="text" id="shop_bank_account" name="shop_bank_account" 
                           value="<?php echo esc_attr($bank_account); ?>" 
                           class="regular-text" placeholder="123456789/0100">
                    <p class="description">Formát: číslo účtu/kód banky (např. 123456789/0100)</p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="shop_variable_symbol">Variabilní symbol</label>
                </th>
                <td>
                    <input type="text" id="shop_variable_symbol" name="shop_variable_symbol" 
                           value="<?php echo esc_attr($variable_symbol); ?>" 
                           class="regular-text" placeholder="1234567890">
                    <p class="description">Ponechte prázdné pro použití ID objednávky</p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="shop_iban">IBAN (volitelné)</label>
                </th>
                <td>
                    <input type="text" id="shop_iban" name="shop_iban" 
                           value="<?php echo esc_attr($iban); ?>" 
                           class="regular-text" placeholder="CZ65 0800 0000 1920 0014 5399">
                    <p class="description">Pro mezinárodní platby</p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="shop_swift">SWIFT/BIC (volitelné)</label>
                </th>
                <td>
                    <input type="text" id="shop_swift" name="shop_swift" 
                           value="<?php echo esc_attr($swift); ?>" 
                           class="regular-text" placeholder="GIBACZPX">
                    <p class="description">Pro mezinárodní platby</p>
                </td>
            </tr>
            
            <tr>
                <th colspan="2">
                    <h2>📱 QR kód pro platbu</h2>
                </th>
            </tr>
            <tr>
                <th scope="row">Povolit QR kód</th>
                <td>
                    <label>
                        <input type="checkbox" name="shop_enable_qr" value="1" 
                               <?php checked($enable_qr, 1); ?>>
                        Zobrazit QR kód v platebních instrukcích
                    </label>
                    <p class="description">QR kód umožní zákazníkům zaplatit naskenováním v mobilní bance</p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="shop_qr_image">URL QR kódu</label>
                </th>
                <td>
                    <input type="text" id="shop_qr_image" name="shop_qr_image" 
                           value="<?php echo esc_attr($qr_image_url); ?>" 
                           class="regular-text" placeholder="https://vase-domena.cz/wp-content/uploads/qr-kod.png">
                    <p class="description">
                        Vložte URL vašeho QR kódu z Media Library<br>
                        <strong>Tip:</strong> Nahrajte QR kód do <a href="<?php echo admin_url('upload.php'); ?>" target="_blank">Média</a>, 
                        zkopírujte URL a vložte sem
                    </p>
                    <?php if (!empty($qr_image_url)): ?>
                        <div style="margin-top: 15px; padding: 15px; background: #f0f0f0; border-radius: 8px;">
                            <p style="margin: 0 0 10px 0;"><strong>Náhled QR kódu:</strong></p>
                            <img src="<?php echo esc_url($qr_image_url); ?>" 
                                 alt="QR kód" 
                                 style="max-width: 200px; height: auto; border: 1px solid #ddd; border-radius: 4px;">
                        </div>
                    <?php endif; ?>
                </td>
            </tr>
        </table>
        
        <p class="submit">
            <button type="submit" name="kr_save_shop_settings" class="button button-primary">
                Uložit nastavení
            </button>
        </p>
    </form>
    
    <hr style="margin: 40px 0;">
    
    <h2>📝 Jak použít prodejní formulář</h2>
    <p>Vložte tento shortcode na libovolnou stránku nebo příspěvek:</p>
    <div style="background: #f0f0f0; padding: 20px; border-radius: 8px; margin: 20px 0;">
        <code style="font-size: 16px; color: #f89820; font-weight: bold;">[kr_koupit]</code>
    </div>
    
    <h3>Příklad použití:</h3>
    <div style="background: #f9f9f9; padding: 20px; border-radius: 8px; border-left: 4px solid #f89820;">
        <p><strong>Vytvořte novou stránku:</strong></p>
        <ol>
            <li>Přejděte na <strong>Stránky → Přidat novou</strong></li>
            <li>Název: "Koupit Kadeřnice Rezervace"</li>
            <li>Vložte shortcode: <code>[kr_koupit]</code></li>
            <li>Publikujte stránku</li>
        </ol>
    </div>
    
    <h3 style="margin-top: 30px;">🎨 Přizpůsobení ceny:</h3>
    <div style="background: #f9f9f9; padding: 20px; border-radius: 8px; border-left: 4px solid #f89820;">
        <code>[kr_koupit cena="990"]</code>
        <p style="margin: 10px 0 0 0; color: #666;">Zobrazí vlastní cenu místo výchozí</p>
    </div>
</div>