<?php
/**
 * Shop orders admin page
 */

if (!defined('ABSPATH')) exit;
?>

<div class="wrap">
    <h1>💰 Prodej pluginu - Objednávky</h1>
    
    <div class="kr-shop-filters" style="margin: 20px 0;">
        <a href="?page=kr-shop" class="button <?php echo empty($filter_status) ? 'button-primary' : ''; ?>">
            Všechny (<?php echo $all_count; ?>)
        </a>
        <a href="?page=kr-shop&status=čeká na platbu" class="button <?php echo $filter_status === 'čeká na platbu' ? 'button-primary' : ''; ?>">
            🟠 Čeká na platbu (<?php echo $pending_count; ?>)
        </a>
        <a href="?page=kr-shop&status=aktivní" class="button <?php echo $filter_status === 'aktivní' ? 'button-primary' : ''; ?>">
            🟢 Aktivní (<?php echo $active_count; ?>)
        </a>
    </div>
    
    <?php if (empty($orders)): ?>
        <div style="text-align: center; padding: 60px 20px; background: #f9f9f9; border-radius: 8px; margin-top: 20px;">
            <p style="font-size: 18px; color: #666; margin-bottom: 20px;">📦 Zatím žádné objednávky</p>
            <p>Vytvořte prodejní stránku pomocí shortcode:</p>
            <code style="background: white; padding: 10px 20px; border-radius: 4px; display: inline-block;">[kr_koupit]</code>
        </div>
    <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 50px;">ID</th>
                    <th>Jméno</th>
                    <th>Email</th>
                    <th>Telefon</th>
                    <th>Firma</th>
                    <th style="width: 100px;">Cena</th>
                    <th style="width: 120px;">Status</th>
                    <th>Licenční klíč</th>
                    <th style="width: 140px;">Vytvořeno</th>
                    <th style="width: 200px;">Akce</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($orders as $order): ?>
                    <tr>
                        <td><strong>#<?php echo $order->id; ?></strong></td>
                        <td><?php echo esc_html($order->name); ?></td>
                        <td><a href="mailto:<?php echo esc_attr($order->email); ?>"><?php echo esc_html($order->email); ?></a></td>
                        <td><?php echo esc_html($order->phone); ?></td>
                        <td><?php echo esc_html($order->company ?: '—'); ?></td>
                        <td><strong><?php echo number_format($order->price, 0, ',', ' '); ?> Kč</strong></td>
                        <td>
                            <?php
                            $status_colors = array(
                                'čeká na platbu' => '#ff9800',
                                'aktivní' => '#22c55e',
                                'zamítnuto' => '#ef4444'
                            );
                            $color = isset($status_colors[$order->status]) ? $status_colors[$order->status] : '#999';
                            ?>
                            <span style="display: inline-block; padding: 5px 12px; background: <?php echo $color; ?>; color: white; border-radius: 4px; font-size: 12px; font-weight: 500;">
                                <?php echo esc_html($order->status); ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($order->license_key): ?>
                                <code style="background: #f0f0f0; padding: 4px 8px; border-radius: 4px; font-size: 11px; display: block; word-break: break-all;">
                                    <?php echo esc_html($order->license_key); ?>
                                </code>
                            <?php else: ?>
                                <span style="color: #999;">—</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('d.m.Y H:i', strtotime($order->created_at)); ?></td>
                        <td>
                            <?php if ($order->status === 'čeká na platbu'): ?>
                                <form method="post" style="display: inline;">
                                    <?php wp_nonce_field('kr_shop_action'); ?>
                                    <input type="hidden" name="kr_shop_action" value="approve">
                                    <input type="hidden" name="order_id" value="<?php echo $order->id; ?>">
                                    <button type="submit" class="button button-primary button-small" 
                                            onclick="return confirm('Schválit platbu a odeslat licenci?')"
                                            style="margin-right: 5px;">
                                        ✓ Schválit
                                    </button>
                                </form>
                            <?php endif; ?>
                            
                            <form method="post" style="display: inline;">
                                <?php wp_nonce_field('kr_shop_action'); ?>
                                <input type="hidden" name="kr_shop_action" value="delete">
                                <input type="hidden" name="order_id" value="<?php echo $order->id; ?>">
                                <button type="submit" class="button button-small" 
                                        onclick="return confirm('Opravdu smazat tuto objednávku?')"
                                        style="color: #d63638;">
                                    🗑 Smazat
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<style>
    .kr-shop-filters { margin: 20px 0; }
    .wp-list-table th { font-weight: 600; }
    .wp-list-table td { vertical-align: middle; }
    .button-small { padding: 3px 10px; font-size: 12px; height: auto; line-height: 1.5; }
</style>