<?php
/**
 * Admin settings page
 */

if (!defined('ABSPATH')) {
    exit;
}

// Save settings
if (isset($_POST['kr_save_settings'])) {
    // Verify nonce with proper field name
    check_admin_referer('kr_settings_save', 'kr_settings_nonce_field');
    
    update_option('kr_business_name', sanitize_text_field($_POST['kr_business_name']));
    update_option('kr_business_email', sanitize_email($_POST['kr_business_email']));
    update_option('kr_business_phone', sanitize_text_field($_POST['kr_business_phone']));
    update_option('kr_business_initials', sanitize_text_field($_POST['kr_business_initials'] ?? ''));
    update_option('kr_booking_interval', intval($_POST['kr_booking_interval']));
    update_option('kr_advance_booking_days', intval($_POST['kr_advance_booking_days']));
    update_option('kr_min_booking_notice', intval($_POST['kr_min_booking_notice']));
    update_option('kr_enable_email_notifications', isset($_POST['kr_enable_email_notifications']) ? 1 : 0);
    update_option('kr_admin_email_on_booking', isset($_POST['kr_admin_email_on_booking']) ? 1 : 0);
    update_option('kr_customer_email_on_booking', isset($_POST['kr_customer_email_on_booking']) ? 1 : 0);
    update_option('kr_currency', sanitize_text_field($_POST['kr_currency']));
    update_option('kr_date_format', sanitize_text_field($_POST['kr_date_format']));
    update_option('kr_time_format', sanitize_text_field($_POST['kr_time_format']));
    update_option('kr_calendar_banner_title', sanitize_text_field($_POST['kr_calendar_banner_title']));
    update_option('kr_calendar_banner_text', sanitize_text_field($_POST['kr_calendar_banner_text']));
    update_option('kr_use_service_colors', isset($_POST['kr_use_service_colors']) ? 1 : 0);
    update_option('kr_error_message', sanitize_textarea_field($_POST['kr_error_message']));

    // SMTP settings
    update_option('kr_smtp_enabled', isset($_POST['kr_smtp_enabled']) ? 1 : 0);
    update_option('kr_smtp_host', sanitize_text_field($_POST['kr_smtp_host']));
    update_option('kr_smtp_port', intval($_POST['kr_smtp_port']));
    update_option('kr_smtp_encryption', sanitize_text_field($_POST['kr_smtp_encryption']));
    update_option('kr_smtp_username', sanitize_text_field($_POST['kr_smtp_username']));
    if (!empty($_POST['kr_smtp_password'])) {
        update_option('kr_smtp_password', sanitize_text_field($_POST['kr_smtp_password']));
    }
    update_option('kr_smtp_from_email', sanitize_email($_POST['kr_smtp_from_email']));
    update_option('kr_smtp_from_name', sanitize_text_field($_POST['kr_smtp_from_name']));

    // SMS settings
    update_option('kr_sms_enabled', isset($_POST['kr_sms_enabled']) ? 1 : 0);
    update_option('kr_sms_provider', sanitize_text_field($_POST['kr_sms_provider']));
    update_option('kr_sms_api_key', sanitize_text_field($_POST['kr_sms_api_key']));
    update_option('kr_sms_api_secret', sanitize_text_field($_POST['kr_sms_api_secret']));
    update_option('kr_sms_sender_id', sanitize_text_field($_POST['kr_sms_sender_id']));
    update_option('kr_sms_admin_notify', isset($_POST['kr_sms_admin_notify']) ? 1 : 0);
    update_option('kr_sms_customer_notify', isset($_POST['kr_sms_customer_notify']) ? 1 : 0);
    update_option('kr_sms_reminder_enabled', isset($_POST['kr_sms_reminder_enabled']) ? 1 : 0);
    update_option('kr_sms_reminder_hours', intval($_POST['kr_sms_reminder_hours']));

    echo '<div class="notice notice-success"><p>' . __('Nastavení bylo uloženo.', 'kadernice-rezervace') . '</p></div>';
}

// Test SMTP connection
if (isset($_POST['kr_test_smtp'])) {
    // Verify nonce with proper field name
    check_admin_referer('kr_test_smtp_action', 'kr_test_smtp_nonce_field');
    
    $test_result = KR_Email::test_smtp_connection();
    if ($test_result['success']) {
        echo '<div class="notice notice-success"><p>' . __('SMTP připojení úspěšné! Testovací email byl odeslán.', 'kadernice-rezervace') . '</p></div>';
    } else {
        echo '<div class="notice notice-error"><p>' . sprintf(__('SMTP chyba: %s', 'kadernice-rezervace'), $test_result['message']) . '</p></div>';
    }
}

// Test SMS
if (isset($_POST['kr_test_sms'])) {
    // Verify nonce with proper field name
    check_admin_referer('kr_test_sms_action', 'kr_test_sms_nonce_field');
    
    $test_phone = sanitize_text_field($_POST['kr_test_phone']);
    $test_result = KR_SMS::send_test_sms($test_phone);
    if ($test_result['success']) {
        echo '<div class="notice notice-success"><p>' . __('SMS byla úspěšně odeslána!', 'kadernice-rezervace') . '</p></div>';
    } else {
        echo '<div class="notice notice-error"><p>' . sprintf(__('SMS chyba: %s', 'kadernice-rezervace'), $test_result['message']) . '</p></div>';
    }
}
?>

<div class="wrap">
    <h1><?php _e('Nastavení', 'kadernice-rezervace'); ?></h1>

    <form method="post" action="">
        <?php wp_nonce_field('kr_settings_save', 'kr_settings_nonce_field'); ?>

        <table class="form-table">
            <tr>
                <th colspan="2">
                    <h2><?php _e('Základní informace', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_business_name"><?php _e('Název provozovny', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_business_name" name="kr_business_name"
                        value="<?php echo esc_attr(get_option('kr_business_name')); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_business_email"><?php _e('Email', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="email" id="kr_business_email" name="kr_business_email"
                        value="<?php echo esc_attr(get_option('kr_business_email')); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_business_phone"><?php _e('Telefon', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_business_phone" name="kr_business_phone"
                        value="<?php echo esc_attr(get_option('kr_business_phone')); ?>" class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_business_initials" style="font-weight: 700; color: #2271b1;">
                        <?php _e('Iniciály', 'kadernice-rezervace'); ?> 
                        <span style="color: #d63638;">*</span>
                    </label>
                </th>
                <td>
                    <input type="text" 
                           id="kr_business_initials" 
                           name="kr_business_initials"
                           value="<?php echo esc_attr(get_option('kr_business_initials', '')); ?>" 
                           class="regular-text" 
                           maxlength="10"
                           placeholder="<?php esc_attr_e('Např. JN, AB, MK', 'kadernice-rezervace'); ?>"
                           style="border: 2px solid #2271b1; background: #f0f6fc;">
                    <p class="description" style="color: #2271b1; font-weight: 600;">
                        <?php _e('Vaše iniciály pro identifikaci v systému (volitelné)', 'kadernice-rezervace'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_error_message"><?php _e('Chybová hláška pro zákazníky', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <textarea id="kr_error_message" name="kr_error_message" rows="3" class="large-text"><?php echo esc_textarea(get_option('kr_error_message', 'Něco se pokazilo. Prosím kontaktujte nás na telefonu ' . get_option('kr_business_phone', ''))); ?></textarea>
                    <p class="description"><?php _e('Tato zpráva se zobrazí zákazníkovi, pokud se nepodaří odeslat rezervaci.', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('Nastavení rezervací', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_booking_interval"><?php _e('Interval rezervací (minuty)', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="number" id="kr_booking_interval" name="kr_booking_interval"
                        value="<?php echo esc_attr(get_option('kr_booking_interval', 30)); ?>" min="15" max="120" step="15">
                    <p class="description"><?php _e('Časový interval mezi jednotlivými termíny', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_advance_booking_days"><?php _e('Předstih rezervace (dny)', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="number" id="kr_advance_booking_days" name="kr_advance_booking_days"
                        value="<?php echo esc_attr(get_option('kr_advance_booking_days', 60)); ?>" min="7" max="365">
                    <p class="description"><?php _e('Kolik dní dopředu mohou zákazníci rezervovat', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_min_booking_notice"><?php _e('Minimální předstih (hodiny)', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="number" id="kr_min_booking_notice" name="kr_min_booking_notice"
                        value="<?php echo esc_attr(get_option('kr_min_booking_notice', 24)); ?>" min="1" max="168">
                    <p class="description"><?php _e('Minimální čas před termínem pro vytvoření rezervace', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('Emailové notifikace', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <th scope="row"><?php _e('Povolit notifikace', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_enable_email_notifications" value="1"
                            <?php checked(get_option('kr_enable_email_notifications', 1), 1); ?>>
                        <?php _e('Odesílat emailové notifikace', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('Notifikace administrátorovi', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_admin_email_on_booking" value="1"
                            <?php checked(get_option('kr_admin_email_on_booking', 1), 1); ?>>
                        <?php _e('Poslat email administrátorovi při nové rezervaci', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('Notifikace zákazníkovi', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_customer_email_on_booking" value="1"
                            <?php checked(get_option('kr_customer_email_on_booking', 1), 1); ?>>
                        <?php _e('Poslat potvrzení zákazníkovi', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('SMTP Nastavení', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="kr-help-box" style="background: #e7f3ff; border-left: 4px solid #2271b1; padding: 12px 16px; margin-bottom: 20px;">
                        <h4 style="margin-top: 0;"><?php _e('📧 Jak nastavit SMTP?', 'kadernice-rezervace'); ?></h4>
                        <p><?php _e('SMTP zajistí spolehlivé doručování emailů. Doporučené poskytovatele:', 'kadernice-rezervace'); ?></p>
                        <ul style="margin-left: 20px;">
                            <li><strong>Gmail:</strong> smtp.gmail.com, Port: 587, TLS | <a href="https://support.google.com/mail/answer/185833" target="_blank">Návod</a></li>
                            <li><strong>Outlook:</strong> smtp-mail.outlook.com, Port: 587, TLS</li>
                            <li><strong>SendGrid:</strong> smtp.sendgrid.net, Port: 587, TLS | <a href="https://sendgrid.com" target="_blank">Registrace</a></li>
                            <li><strong>Mailgun:</strong> smtp.mailgun.org, Port: 587, TLS | <a href="https://mailgun.com" target="_blank">Registrace</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('Povolit SMTP', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_smtp_enabled" value="1" id="kr_smtp_enabled"
                            <?php checked(get_option('kr_smtp_enabled', 0), 1); ?>>
                        <?php _e('Použít SMTP pro odesílání emailů', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_host"><?php _e('SMTP Server', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="text" id="kr_smtp_host" name="kr_smtp_host"
                        value="<?php echo esc_attr(get_option('kr_smtp_host')); ?>"
                        class="regular-text" placeholder="smtp.gmail.com">
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_port"><?php _e('SMTP Port', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="number" id="kr_smtp_port" name="kr_smtp_port"
                        value="<?php echo esc_attr(get_option('kr_smtp_port', 587)); ?>"
                        class="small-text">
                    <p class="description"><?php _e('Obvykle 587 (TLS) nebo 465 (SSL)', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_encryption"><?php _e('Šifrování', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <select id="kr_smtp_encryption" name="kr_smtp_encryption">
                        <option value="tls" <?php selected(get_option('kr_smtp_encryption', 'tls'), 'tls'); ?>>TLS</option>
                        <option value="ssl" <?php selected(get_option('kr_smtp_encryption'), 'ssl'); ?>>SSL</option>
                        <option value="" <?php selected(get_option('kr_smtp_encryption'), ''); ?>><?php _e('Žádné', 'kadernice-rezervace'); ?></option>
                    </select>
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_username"><?php _e('SMTP Uživatel', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="text" id="kr_smtp_username" name="kr_smtp_username"
                        value="<?php echo esc_attr(get_option('kr_smtp_username')); ?>"
                        class="regular-text" placeholder="vas@email.cz">
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_password"><?php _e('SMTP Heslo', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="password" id="kr_smtp_password" name="kr_smtp_password"
                        value="<?php echo esc_attr(get_option('kr_smtp_password')); ?>"
                        class="regular-text" placeholder="<?php _e('Heslo nebo App Password', 'kadernice-rezervace'); ?>">
                    <p class="description"><?php _e('Pro Gmail použijte App Password (ne běžné heslo)', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_from_email"><?php _e('Odesílatel Email', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="email" id="kr_smtp_from_email" name="kr_smtp_from_email"
                        value="<?php echo esc_attr(get_option('kr_smtp_from_email', get_option('admin_email'))); ?>"
                        class="regular-text">
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row">
                    <label for="kr_smtp_from_name"><?php _e('Odesílatel Jméno', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_smtp_from_name" name="kr_smtp_from_name"
                        value="<?php echo esc_attr(get_option('kr_smtp_from_name', get_bloginfo('name'))); ?>"
                        class="regular-text">
                </td>
            </tr>
            <tr class="kr-smtp-field">
                <th scope="row"><?php _e('Test SMTP', 'kadernice-rezervace'); ?></th>
                <td>
                    <form method="post" action="" style="display: inline;">
                        <?php wp_nonce_field('kr_test_smtp_action', 'kr_test_smtp_nonce_field'); ?>
                        <button type="submit" name="kr_test_smtp" class="button">
                            <?php _e('Odeslat testovací email', 'kadernice-rezervace'); ?>
                        </button>
                    </form>
                    <p class="description"><?php _e('Odešle testovací email na adresu administrátora', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('SMS Notifikace', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="kr-help-box" style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 12px 16px; margin-bottom: 20px;">
                        <h4 style="margin-top: 0;"><?php _e('📱 Jak nastavit SMS?', 'kadernice-rezervace'); ?></h4>
                        <p><?php _e('Pro odesílání SMS potřebujete účet u SMS poskytovatele:', 'kadernice-rezervace'); ?></p>
                        <ul style="margin-left: 20px;">
                            <li><strong>Twilio:</strong> Mezinárodní, spolehlivý | <a href="https://www.twilio.com/try-twilio" target="_blank">Registrace zdarma</a></li>
                            <li><strong>SMSBrana.cz:</strong> České SMS brány | <a href="https://www.smsbrana.cz" target="_blank">Registrace</a></li>
                            <li><strong>Nexmo (Vonage):</strong> Globální pokrytí | <a href="https://www.vonage.com" target="_blank">Registrace</a></li>
                        </ul>
                        <p><strong><?php _e('Postup:', 'kadernice-rezervace'); ?></strong></p>
                        <ol style="margin-left: 20px;">
                            <li><?php _e('Zaregistrujte se u poskytovatele', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Získejte API klíč a tajný klíč', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Vyplňte údaje níže', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Otestujte připojení', 'kadernice-rezervace'); ?></li>
                        </ol>
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('Povolit SMS', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_sms_enabled" value="1" id="kr_sms_enabled"
                            <?php checked(get_option('kr_sms_enabled', 0), 1); ?>>
                        <?php _e('Odesílat SMS notifikace', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row">
                    <label for="kr_sms_provider"><?php _e('SMS Poskytovatel', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <select id="kr_sms_provider" name="kr_sms_provider">
                        <option value="twilio" <?php selected(get_option('kr_sms_provider'), 'twilio'); ?>>Twilio</option>
                        <option value="smsbrana" <?php selected(get_option('kr_sms_provider'), 'smsbrana'); ?>>SMSBrana.cz</option>
                        <option value="nexmo" <?php selected(get_option('kr_sms_provider'), 'nexmo'); ?>>Nexmo (Vonage)</option>
                    </select>
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row">
                    <label for="kr_sms_api_key"><?php _e('API Klíč', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="text" id="kr_sms_api_key" name="kr_sms_api_key"
                        value="<?php echo esc_attr(get_option('kr_sms_api_key')); ?>"
                        class="regular-text">
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row">
                    <label for="kr_sms_api_secret"><?php _e('API Secret / Token', 'kadernice-rezervace'); ?> *</label>
                </th>
                <td>
                    <input type="password" id="kr_sms_api_secret" name="kr_sms_api_secret"
                        value="<?php echo esc_attr(get_option('kr_sms_api_secret')); ?>"
                        class="regular-text">
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row">
                    <label for="kr_sms_sender_id"><?php _e('Odesílatel (Sender ID)', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_sms_sender_id" name="kr_sms_sender_id"
                        value="<?php echo esc_attr(get_option('kr_sms_sender_id')); ?>"
                        class="regular-text" placeholder="<?php _e('Např.: KADERNICE', 'kadernice-rezervace'); ?>">
                    <p class="description"><?php _e('Jméno odesílatele (max 11 znaků, bez diakritiky)', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row"><?php _e('SMS notifikace', 'kadernice-rezervace'); ?></th>
                <td>
                    <label style="display: block; margin-bottom: 8px;">
                        <input type="checkbox" name="kr_sms_admin_notify" value="1"
                            <?php checked(get_option('kr_sms_admin_notify', 0), 1); ?>>
                        <?php _e('Poslat SMS administrátorovi při nové rezervaci', 'kadernice-rezervace'); ?>
                    </label>
                    <label style="display: block; margin-bottom: 8px;">
                        <input type="checkbox" name="kr_sms_customer_notify" value="1"
                            <?php checked(get_option('kr_sms_customer_notify', 0), 1); ?>>
                        <?php _e('Poslat SMS zákazníkovi s potvrzením', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row"><?php _e('SMS připomínka', 'kadernice-rezervace'); ?></th>
                <td>
                    <label style="display: block; margin-bottom: 12px;">
                        <input type="checkbox" name="kr_sms_reminder_enabled" value="1" id="kr_sms_reminder_enabled"
                            <?php checked(get_option('kr_sms_reminder_enabled', 0), 1); ?>>
                        <?php _e('Poslat SMS připomínku před termínem', 'kadernice-rezervace'); ?>
                    </label>
                    <div id="kr_sms_reminder_hours_field" style="<?php echo get_option('kr_sms_reminder_enabled') ? '' : 'display:none;'; ?>">
                        <input type="number" name="kr_sms_reminder_hours"
                            value="<?php echo esc_attr(get_option('kr_sms_reminder_hours', 24)); ?>"
                            min="1" max="168" class="small-text">
                        <?php _e('hodin před termínem', 'kadernice-rezervace'); ?>
                    </div>
                </td>
            </tr>
            <tr class="kr-sms-field">
                <th scope="row"><?php _e('Test SMS', 'kadernice-rezervace'); ?></th>
                <td>
                    <form method="post" action="" style="display: inline-block;">
                        <?php wp_nonce_field('kr_test_sms_action', 'kr_test_sms_nonce_field'); ?>
                        <input type="tel" name="kr_test_phone" placeholder="+420123456789" class="regular-text" required>
                        <button type="submit" name="kr_test_sms" class="button">
                            <?php _e('Odeslat testovací SMS', 'kadernice-rezervace'); ?>
                        </button>
                    </form>
                    <p class="description"><?php _e('Zadejte telefonní číslo ve formátu +420...', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('Vzhled kalendáře', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_calendar_banner_title"><?php _e('Nadpis banneru', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_calendar_banner_title" name="kr_calendar_banner_title"
                        value="<?php echo esc_attr(get_option('kr_calendar_banner_title', 'Vyberte termín pro: {service}')); ?>"
                        class="regular-text">
                    <p class="description"><?php _e('Použijte {service} pro název služby', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_calendar_banner_text"><?php _e('Text banneru', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_calendar_banner_text" name="kr_calendar_banner_text"
                        value="<?php echo esc_attr(get_option('kr_calendar_banner_text', 'Klikněte na dostupný den v kalendáři')); ?>"
                        class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('Barevné služby', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_use_service_colors" value="1"
                            <?php checked(get_option('kr_use_service_colors', 1), 1); ?>>
                        <?php _e('Použít barvy služeb pro pozadí karet a banner', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('Platební brána', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="kr-help-box" style="background: #e7f5e8; border-left: 4px solid #28a745; padding: 12px 16px; margin-bottom: 20px;">
                        <h4 style="margin-top: 0;"><?php _e('💳 Jak nastavit platební bránu?', 'kadernice-rezervace'); ?></h4>
                        <p><?php _e('Integrace platební brány umožní zákazníkům platit online při rezervaci. Doporučené poskytovatele:', 'kadernice-rezervace'); ?></p>
                        <ul style="margin-left: 20px;">
                            <li><strong>Stripe:</strong> Mezinárodní platby, jednoduché API | <a href="https://stripe.com" target="_blank">Registrace</a></li>
                            <li><strong>GoPay:</strong> České platby, nejpoužívanější v ČR | <a href="https://www.gopay.com" target="_blank">Registrace</a></li>
                            <li><strong>ComGate:</strong> České platby, nízké poplatky | <a href="https://www.comgate.cz" target="_blank">Registrace</a></li>
                            <li><strong>PayPal:</strong> Globální platby | <a href="https://www.paypal.com" target="_blank">Registrace</a></li>
                        </ul>
                        <p><strong><?php _e('Postup integrace:', 'kadernice-rezervace'); ?></strong></p>
                        <ol style="margin-left: 20px;">
                            <li><?php _e('Zaregistrujte se u poskytovatele platební brány', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Získejte API klíče (testovací i produkční)', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Vyplňte údaje níže', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Otestujte platbu v testovacím režimu', 'kadernice-rezervace'); ?></li>
                            <li><?php _e('Přepněte na produkční režim', 'kadernice-rezervace'); ?></li>
                        </ol>
                        <p style="background: #fff3cd; padding: 8px 12px; border-radius: 4px; margin-top: 12px;">
                            <strong>⚠️ Poznámka:</strong> <?php _e('Tato funkce je momentálně ve vývoji. Pro aktivaci kontaktujte podporu.', 'kadernice-rezervace'); ?>
                        </p>
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('Povolit platby', 'kadernice-rezervace'); ?></th>
                <td>
                    <label>
                        <input type="checkbox" name="kr_payment_enabled" value="1" id="kr_payment_enabled"
                            <?php checked(get_option('kr_payment_enabled', 0), 1); ?> disabled>
                        <?php _e('Povolit online platby (funkce ve vývoji)', 'kadernice-rezervace'); ?>
                    </label>
                </td>
            </tr>

            <tr>
                <th colspan="2">
                    <h2><?php _e('Formátování', 'kadernice-rezervace'); ?></h2>
                </th>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_currency"><?php _e('Měna', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_currency" name="kr_currency"
                        value="<?php echo esc_attr(get_option('kr_currency', 'Kč')); ?>" class="small-text">
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_date_format"><?php _e('Formát data', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_date_format" name="kr_date_format"
                        value="<?php echo esc_attr(get_option('kr_date_format', 'd.m.Y')); ?>" class="small-text">
                    <p class="description"><?php _e('Např.: d.m.Y, Y-m-d', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="kr_time_format"><?php _e('Formát času', 'kadernice-rezervace'); ?></label>
                </th>
                <td>
                    <input type="text" id="kr_time_format" name="kr_time_format"
                        value="<?php echo esc_attr(get_option('kr_time_format', 'H:i')); ?>" class="small-text">
                    <p class="description"><?php _e('Např.: H:i, h:i A', 'kadernice-rezervace'); ?></p>
                </td>
            </tr>
        </table>

        <p class="submit">
            <button type="submit" name="kr_save_settings" class="button button-primary">
                <?php _e('Uložit nastavení', 'kadernice-rezervace'); ?>
            </button>
        </p>
    </form>

    <hr>

    <h2><?php _e('Shortcode', 'kadernice-rezervace'); ?></h2>
    <p><?php _e('Vložte tento shortcode na stránku nebo do příspěvku:', 'kadernice-rezervace'); ?></p>
    <code>[kadernice_rezervace]</code>

    <h2><?php _e('Gutenberg blok', 'kadernice-rezervace'); ?></h2>
    <p><?php _e('V editoru vyhledejte blok "Kadeřnice Rezervace"', 'kadernice-rezervace'); ?></p>
    
    <hr style="margin: 40px 0;">
    
    <h2><?php _e('📚 Návody a dokumentace', 'kadernice-rezervace'); ?></h2>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 20px;">
        
        <!-- Quick Start Guide -->
        <div style="background: #f0f6fc; border: 2px solid #2271b1; border-radius: 8px; padding: 20px;">
            <h3 style="margin-top: 0; color: #2271b1;">🚀 Rychlý start</h3>
            <ol style="margin-left: 20px; line-height: 1.8;">
                <li>Nastavte pracovní dobu v sekci "Pracovní doba"</li>
                <li>Přidejte služby v sekci "Služby"</li>
                <li>Zkontrolujte nastavení (email, telefon)</li>
                <li>Vložte shortcode <code>[kadernice_rezervace]</code> na stránku</li>
                <li>Otestujte rezervaci</li>
            </ol>
        </div>
        
        <!-- Email Setup -->
        <div style="background: #fff3cd; border: 2px solid #ffc107; border-radius: 8px; padding: 20px;">
            <h3 style="margin-top: 0; color: #856404;">📧 Nastavení emailů</h3>
            <p><strong>Doporučujeme SMTP pro spolehlivé doručování:</strong></p>
            <ul style="margin-left: 20px; line-height: 1.8;">
                <li><strong>Gmail:</strong> smtp.gmail.com:587 (TLS)</li>
                <li>Použijte App Password, ne běžné heslo</li>
                <li><a href="https://support.google.com/mail/answer/185833" target="_blank">Návod na App Password</a></li>
            </ul>
            <p style="margin-top: 12px;"><a href="?page=kr-settings#smtp" class="button">→ Nastavit SMTP</a></p>
        </div>
        
        <!-- Calendar Colors -->
        <div style="background: #e7f5e8; border: 2px solid #28a745; border-radius: 8px; padding: 20px;">
            <h3 style="margin-top: 0; color: #155724;">🎨 Barevné značení kalendáře</h3>
            <ul style="margin-left: 20px; line-height: 1.8;">
                <li><span style="color: #28a745;">●</span> <strong>Zelená:</strong> Volné termíny k rezervaci</li>
                <li><span style="color: #ffc107;">●</span> <strong>Žlutá:</strong> Částečně obsazeno</li>
                <li><span style="color: #dc3545;">●</span> <strong>Červená:</strong> Plně obsazeno</li>
                <li><span style="color: #6c757d;">●</span> <strong>Šedá:</strong> Zavřeno/Dovolená</li>
            </ul>
        </div>
        
        <!-- SMS Setup -->
        <div style="background: #f8d7da; border: 2px solid #dc3545; border-radius: 8px; padding: 20px;">
            <h3 style="margin-top: 0; color: #721c24;">📱 SMS Notifikace</h3>
            <p><strong>Poskytovatele SMS služeb:</strong></p>
            <ul style="margin-left: 20px; line-height: 1.8;">
                <li><strong>Twilio:</strong> Mezinárodní, spolehlivý</li>
                <li><strong>SMSBrana.cz:</strong> České SMS brány</li>
                <li>Potřebujete API klíč a tajný klíč</li>
            </ul>
            <p style="margin-top: 12px;"><a href="?page=kr-settings#sms" class="button">→ Nastavit SMS</a></p>
        </div>
        
        <!-- Payment Gateway -->
        <div style="background: #e0f2fe; border: 2px solid #0ea5e9; border-radius: 8px; padding: 20px;">
            <h3 style="margin-top: 0; color: #075985;">💳 Platební brána</h3>
            <p><strong>Online platby (ve vývoji):</strong></p>
            <ul style="margin-left: 20px; line-height: 1.8;">
                <li>GoPay - nejpoužívanější v ČR</li>
                <li>Stripe - mezinárodní platby</li>
                <li>ComGate - nízké poplatky</li>
            </ul>
            <p style="margin-top: 12px;"><a href="?page=kr-settings#payment" class="button">→ Nastavení plateb</a></p>
        </div>
        
        <!-- Support -->
        <div style="background: #f3e5f5; border: 2px solid #9c27b0; border-radius: 8px; padding: 20px;">
            <h3 style="margin-top: 0; color: #6a1b9a;">💬 Podpora</h3>
            <p><strong>Potřebujete pomoc?</strong></p>
            <ul style="margin-left: 20px; line-height: 1.8;">
                <li>📧 Email: andersova.ji@gmail.com</li>
                <li>📞 Telefon: +420 702 432 886</li>
                <li>📖 <a href="#" target="_blank">Kompletní dokumentace</a></li>
                <li>🎥 <a href="#" target="_blank">Video návody</a></li>
            </ul>
        </div>
        
    </div>
</div>

<script>
    jQuery(document).ready(function($) {
        // Toggle SMTP fields
        function toggleSMTPFields() {
            if ($('#kr_smtp_enabled').is(':checked')) {
                $('.kr-smtp-field').show();
            } else {
                $('.kr-smtp-field').hide();
            }
        }

        $('#kr_smtp_enabled').on('change', toggleSMTPFields);
        toggleSMTPFields();

        // Toggle SMS fields
        function toggleSMSFields() {
            if ($('#kr_sms_enabled').is(':checked')) {
                $('.kr-sms-field').show();
            } else {
                $('.kr-sms-field').hide();
            }
        }

        $('#kr_sms_enabled').on('change', toggleSMSFields);
        toggleSMSFields();

        // Toggle SMS reminder hours
        $('#kr_sms_reminder_enabled').on('change', function() {
            if ($(this).is(':checked')) {
                $('#kr_sms_reminder_hours_field').show();
            } else {
                $('#kr_sms_reminder_hours_field').hide();
            }
        });
    });
</script>