<?php
/**
 * License page
 */

if (!defined('ABSPATH')) exit;

// Načtení nastavení z rezervace-admin (pokud je aktivní)
$is_admin_plugin_active = is_plugin_active('rezervace-admin/rezervace-admin.php');

if ($is_admin_plugin_active) {
    // Načíst data z rezervace-admin
    $buy_url = get_option('ra_kr_buy_url', home_url('/koupit-kadernice-rezervace'));
    $plugin_price = get_option('ra_kr_price', 2990);
    $bank_account = get_option('ra_kr_bank_account', '');
    $enable_qr = get_option('ra_kr_enable_qr', 0);
} else {
    // Výchozí hodnoty
    $buy_url = 'https://vase-domena.cz/koupit-kadernice-rezervace';
    $plugin_price = 2990;
    $bank_account = '';
    $enable_qr = 0;
}

// Formátování ceny
$formatted_price = number_format($plugin_price, 0, ',', ' ');
?>

<div class="wrap kr-license-page">
    <h1>🔑 Licence pluginu</h1>
    
    <?php if ($is_admin_plugin_active && !empty($bank_account)): ?>
        <!-- Info box o propojení -->
        <div style="background: #e7f3ff; border-left: 4px solid #2271b1; padding: 15px; margin: 20px 0; border-radius: 4px;">
            <p style="margin: 0;">
                <strong>ℹ️ Informace:</strong> 
                Aktuální cena licence je <strong><?php echo esc_html($formatted_price); ?> Kč</strong>. 
                Po kliknutí na tlačítko "🛒 Koupit licenci" budete přesměrováni na bezpečnou prodejní stránku s platebními instrukcemi.
            </p>
        </div>
    <?php endif; ?>
    
    <?php if ($license_data['status'] === 'active'): ?>
        <!-- Active License -->
        <div class="kr-license-active" style="background: #d4edda; border: 2px solid #28a745; padding: 30px; border-radius: 12px; margin: 20px 0;">
            <h2 style="margin-top: 0; color: #28a745;">
                ✅ Licence je aktivní
            </h2>
            
            <table class="form-table">
                <tr>
                    <th>Typ licence:</th>
                    <td>
                        <?php if ($license_data['type'] === 'demo'): ?>
                            <strong style="color: #ff9800;">🎯 DEMO verze (14 dní zdarma)</strong>
                        <?php else: ?>
                            <strong style="color: #28a745;">💎 Plná verze</strong>
                        <?php endif; ?>
                    </td>
                </tr>
                <tr>
                    <th>Licenční klíč:</th>
                    <td><code style="background: #f0f0f0; padding: 5px 10px; border-radius: 4px;"><?php echo esc_html($license_data['key']); ?></code></td>
                </tr>
                <?php if ($license_data['email']): ?>
                <tr>
                    <th>Email:</th>
                    <td><?php echo esc_html($license_data['email']); ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <th>Aktivováno:</th>
                    <td><?php echo date('d.m.Y H:i', strtotime($license_data['activated_at'])); ?></td>
                </tr>
                <tr>
                    <th>Platnost do:</th>
                    <td>
                        <strong><?php echo date('d.m.Y', strtotime($license_data['expires_at'])); ?></strong>
                        <?php
                        $days_left = floor((strtotime($license_data['expires_at']) - time()) / 86400);
                        if ($days_left > 0) {
                            echo " <span style='color: #666;'>(" . $days_left . " " . ($days_left === 1 ? 'den' : 'dní') . ")</span>";
                        }
                        ?>
                    </td>
                </tr>
            </table>
            
            <?php if ($license_data['type'] === 'demo'): ?>
                <div style="background: #fff3cd; border-left: 4px solid #ffc107; padding: 20px; margin: 20px 0; border-radius: 4px;">
                    <h3 style="margin-top: 0;">💡 Používáte DEMO verzi</h3>
                    <p>Po vypršení demo verze bude plugin deaktivován. Zakupte plnou licenci pro neomezené použití!</p>
                    <div style="margin: 15px 0;">
                        <p style="font-size: 20px; font-weight: bold; color: #f89820; margin: 10px 0;">
                            Cena: <?php echo esc_html($formatted_price); ?> Kč
                        </p>
                    </div>
                    <a href="<?php echo esc_url($buy_url); ?>" class="button button-primary button-hero" target="_blank" style="text-decoration: none;">
                        🛒 Koupit plnou licenci
                    </a>
                </div>
            <?php endif; ?>
            
            <p style="margin-top: 30px;">
                <button type="button" class="button" onclick="krDeactivateLicense()">
                    Deaktivovat licenci
                </button>
            </p>
        </div>
        
    <?php elseif ($license_data['status'] === 'expired'): ?>
        <!-- Expired License -->
        <div class="kr-license-expired" style="background: #f8d7da; border: 2px solid #dc3545; padding: 30px; border-radius: 12px; margin: 20px 0;">
            <h2 style="margin-top: 0; color: #dc3545;">
                🔒 Licence vypršela
            </h2>
            
            <p style="font-size: 16px;">
                <?php if ($license_data['type'] === 'demo'): ?>
                    Vaše 14denní demo verze vypršela. Plugin je nyní deaktivován.
                <?php else: ?>
                    Vaše licence vypršela dne <strong><?php echo date('d.m.Y', strtotime($license_data['expires_at'])); ?></strong>.
                <?php endif; ?>
            </p>
            
            <div style="background: white; padding: 20px; border-radius: 8px; margin: 20px 0;">
                <h3>🛒 Zakupte plnou licenci</h3>
                <p>Získejte neomezený přístup ke všem funkcím pluginu:</p>
                <ul style="line-height: 2;">
                    <li>✓ Neomezený počet rezervací</li>
                    <li>✓ Email a SMS notifikace</li>
                    <li>✓ Automatické aktualizace</li>
                    <li>✓ Technická podpora</li>
                    <li>✓ Přístup k dokumentaci</li>
                </ul>
                <a href="<?php echo esc_url($buy_url); ?>" class="button button-primary button-hero" target="_blank" style="text-decoration: none;">
                    🛒 Koupit plnou licenci (<?php echo esc_html($formatted_price); ?> Kč)
                </a>
            </div>
            
            <p style="margin-top: 30px; color: #666;">
                Již máte licenční klíč? <a href="#" onclick="document.getElementById('kr-activate-form').style.display='block'; return false;">Aktivujte ho zde</a>
            </p>
        </div>
        
        <!-- Activation Form (hidden) -->
        <div id="kr-activate-form" style="display: none; background: white; border: 2px solid #2271b1; padding: 30px; border-radius: 12px; margin: 20px 0;">
            <h3>Aktivace licence</h3>
            <form id="license-activate-form">
                <table class="form-table">
                    <tr>
                        <th><label for="license_key">Licenční klíč *</label></th>
                        <td>
                            <input type="text" id="license_key" name="license_key" class="regular-text" 
                                   placeholder="KR-XXXX-XXXX-XXXX-XXXX" required>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="license_email">Email *</label></th>
                        <td>
                            <input type="email" id="license_email" name="email" class="regular-text" 
                                   placeholder="vas@email.cz" required>
                            <p class="description">Email použitý při nákupu</p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <button type="submit" class="button button-primary">Aktivovat licenci</button>
                </p>
            </form>
            <div id="license-message"></div>
        </div>
        
    <?php else: ?>
        <!-- No License -->
        <div class="kr-license-none" style="background: #f0f7ff; border: 2px solid #2271b1; padding: 30px; border-radius: 12px; margin: 20px 0;">
            <h2 style="margin-top: 0; color: #2271b1;">
                Vítejte v pluginu Kadeřnice Rezervace!
            </h2>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; margin: 30px 0;">
                <!-- Demo -->
                <div style="background: white; padding: 30px; border-radius: 12px; border: 2px solid #ff9800;">
                    <h3 style="margin-top: 0; color: #ff9800;">🎯 Vyzkoušet DEMO</h3>
                    <p style="font-size: 18px; font-weight: bold; color: #ff9800;">14 dní zdarma</p>
                    <ul style="line-height: 2; margin: 20px 0;">
                        <li>✓ Všechny funkce pluginu</li>
                        <li>✓ Bez omezení</li>
                        <li>✓ Žádná platební karta</li>
                    </ul>
                    <?php if (!get_option('kr_demo_used', 0)): ?>
                        <button type="button" class="button button-primary button-hero" onclick="krStartDemo()">
                            🚀 Spustit DEMO verzi
                        </button>
                    <?php else: ?>
                        <p style="color: #999;">Demo verze již byla použita.</p>
                    <?php endif; ?>
                </div>
                
                <!-- Full License -->
                <div style="background: white; padding: 30px; border-radius: 12px; border: 2px solid #28a745;">
                    <h3 style="margin-top: 0; color: #28a745;">💎 Plná licence</h3>
                    <p style="font-size: 18px; font-weight: bold; color: #28a745;">
                        <?php echo esc_html($formatted_price); ?> Kč
                        <?php if ($is_admin_plugin_active): ?>
                            <span style="font-size: 14px; font-weight: normal; color: #666;"> / jednorázově</span>
                        <?php else: ?>
                            <span style="font-size: 14px; font-weight: normal; color: #666;"> / rok</span>
                        <?php endif; ?>
                    </p>
                    <ul style="line-height: 2; margin: 20px 0;">
                        <li>✓ Neomezené použití</li>
                        <li>✓ Automatické aktualizace</li>
                        <li>✓ Technická podpora</li>
                        <li>✓ Přístup k dokumentaci</li>
                    </ul>
                    <a href="<?php echo esc_url($buy_url); ?>" class="button button-primary button-hero" target="_blank" style="text-decoration: none;">
                        🛒 Koupit licenci
                    </a>
                    <p style="margin-top: 15px; font-size: 13px; color: #666;">
                        <a href="#" onclick="document.getElementById('kr-activate-form').style.display='block'; return false;">
                            Již máte licenční klíč? Aktivujte ho zde →
                        </a>
                    </p>
                </div>
            </div>
        </div>
        
        <!-- Activation Form (hidden) -->
        <div id="kr-activate-form" style="display: none; background: white; border: 2px solid #2271b1; padding: 30px; border-radius: 12px; margin: 20px 0;">
            <h3>Aktivace licence</h3>
            <form id="license-activate-form">
                <table class="form-table">
                    <tr>
                        <th><label for="license_key">Licenční klíč *</label></th>
                        <td>
                            <input type="text" id="license_key" name="license_key" class="regular-text" 
                                   placeholder="KR-XXXX-XXXX-XXXX-XXXX" required>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="license_email">Email *</label></th>
                        <td>
                            <input type="email" id="license_email" name="email" class="regular-text" 
                                   placeholder="vas@email.cz" required>
                            <p class="description">Email použitý při nákupu</p>
                        </td>
                    </tr>
                </table>
                <p class="submit">
                    <button type="submit" class="button button-primary">Aktivovat licenci</button>
                </p>
            </form>
            <div id="license-message"></div>
        </div>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    // Start demo
    window.krStartDemo = function() {
        if (!confirm('Spustit 14denní DEMO verzi?')) return;
        
        $.post(ajaxurl, {
            action: 'kr_start_demo',
            nonce: '<?php echo wp_create_nonce('kr-license-nonce'); ?>'
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                location.reload();
            } else {
                alert(response.data.message);
            }
        });
    };
    
    // Activate license
    $('#license-activate-form').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $btn = $form.find('button[type="submit"]');
        var $message = $('#license-message');
        
        $btn.prop('disabled', true).text('Aktivuji...');
        $message.hide();
        
        $.post(ajaxurl, {
            action: 'kr_activate_license',
            nonce: '<?php echo wp_create_nonce('kr-license-nonce'); ?>',
            license_key: $('#license_key').val(),
            email: $('#license_email').val()
        }, function(response) {
            if (response.success) {
                $message.html('<div class="notice notice-success"><p>' + response.data.message + '</p></div>').show();
                setTimeout(function() { location.reload(); }, 1500);
            } else {
                $message.html('<div class="notice notice-error"><p>' + response.data.message + '</p></div>').show();
                $btn.prop('disabled', false).text('Aktivovat licenci');
            }
        });
    });
    
    // Deactivate license
    window.krDeactivateLicense = function() {
        if (!confirm('Opravdu chcete deaktivovat licenci?')) return;
        
        $.post(ajaxurl, {
            action: 'kr_deactivate_license',
            nonce: '<?php echo wp_create_nonce('kr-license-nonce'); ?>'
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                location.reload();
            }
        });
    };
});
</script>

<style>
.kr-license-page h2 {
    font-size: 24px;
}
.kr-license-page .form-table th {
    width: 200px;
    font-weight: 600;
}
.button-hero {
    padding: 12px 24px !important;
    height: auto !important;
    font-size: 16px !important;
}
@media (max-width: 782px) {
    .kr-license-none > div {
        grid-template-columns: 1fr !important;
    }
}
</style>