# Kadeřnice Rezervace - WordPress Plugin

Kompletní rezervační systém pro kadeřnictví s kalendářem, správou služeb a online rezervacemi.

## 🎯 Funkce

### Základní funkce

- ✅ Interaktivní kalendář s výběrem termínů
- ✅ Správa služeb (střih, barvení, melír, atd.)
- ✅ Časové sloty s kontrolou dostupnosti
- ✅ Rezervační formulář s validací
- ✅ Email notifikace pro zákazníky i administrátory
- ✅ Responzivní design
- ✅ Shortcode `[kadernice_rezervace]`
- ✅ Gutenberg blok
- ✅ Kompletní admin rozhraní

### Admin funkce

- 📊 Přehled všech rezervací
- 🔧 Správa služeb (ceny, doba trvání, barvy)
- ⏰ Nastavení pracovní doby
- 🚫 Blokování konkrétních datumů
- ⚙️ Konfigurovatelné nastavení
- 📧 Email šablony

## 📦 Instalace

### Automatická instalace

1. Stáhněte ZIP soubor pluginu
2. V WordPress admin přejděte na **Pluginy → Přidat nový**
3. Klikněte na **Nahrát plugin**
4. Vyberte ZIP soubor a klikněte na **Instalovat**
5. Po instalaci klikněte na **Aktivovat**

### Manuální instalace

1. Nahrajte složku `wp-kadernice-rezervace` do `/wp-content/plugins/`
2. Aktivujte plugin v sekci **Pluginy** ve WordPress admin

## 🚀 Rychlý start

### 1. Uvítací obrazovka

Po aktivaci pluginu se automaticky zobrazí **uvítací obrazovka** s možnostmi:

**Automatické vytvoření stránky:**

- Klikněte na tlačítko "Vytvořit rezervační stránku"
- Stránka s názvem "Rezervace" bude automaticky vytvořena
- Shortcode `[kadernice_rezervace]` bude již vložen

**Manuální vložení:**

- Zkopírujte shortcode `[kadernice_rezervace]` tlačítkem "Zkopírovat"
- Vložte ho na libovolnou stránku nebo příspěvek
- Nebo použijte Gutenberg blok "Kadeřnice Rezervace"

### 2. První nastavení

Po vytvoření stránky:

1. Přejděte na **Rezervace → Nastavení**
2. Vyplňte základní informace:
   - Název provozovny
   - Email
   - Telefon
3. Nastavte rezervační parametry:
   - Interval rezervací (výchozí 30 minut)
   - Předstih rezervace (výchozí 60 dní)
   - Minimální předstih (výchozí 24 hodin)

### 3. Nastavení služeb

1. Přejděte na **Rezervace → Služby**
2. Plugin vytvoří výchozí služby:
   - Dámský střih (60 min, 500 Kč)
   - Pánský střih (30 min, 300 Kč)
   - Barvení (120 min, 1200 Kč)
   - Melír (90 min, 900 Kč)
   - Trvalá (120 min, 1000 Kč)
3. Klikněte na "Upravit" u každé služby pro změnu parametrů
4. Nebo přidejte nové služby tlačítkem "Přidat novou"

### 4. Nastavení pracovní doby

1. Přejděte na **Rezervace → Pracovní doba**
2. Výchozí nastavení: Po-Pá 9:00-17:00
3. Zaškrtněte dny, kdy jste otevřeni
4. Nastavte časy Od-Do
5. Klikněte "Uložit pracovní dobu"

### 5. Přístup k uvítací obrazovce

Pokud potřebujete znovu zobrazit uvítací obrazovku:

- Přejděte na URL: `wp-admin/index.php?page=kr-welcome`
- Nebo klikněte na notifikaci v admin panelu (pokud se zobrazuje)

## 📖 Použití

### Pro zákazníky

Proces rezervace má 4 kroky:

1. **Výběr služby** - Zákazník si vybere požadovanou službu
2. **Výběr data** - V kalendáři vybere dostupný termín
3. **Výběr času** - Vybere konkrétní čas z dostupných slotů
4. **Vyplnění údajů** - Zadá jméno, email, telefon a poznámku

Po odeslání obdrží potvrzovací email.

### Pro administrátory

**Správa rezervací:**

- Zobrazení všech rezervací
- Filtrování podle data a statusu
- Změna statusu (čekající, potvrzené, zrušené, dokončené)
- Smazání rezervace

**Správa služeb:**

- Přidání nové služby
- Úprava názvu, popisu, ceny, doby trvání
- Nastavení barvy pro kalendář
- Aktivace/deaktivace služby

**Pracovní doba:**

- Nastavení pro každý den v týdnu
- Různé časy pro různé dny
- Možnost zavřít konkrétní den

**Blokování datumů:**

- Blokování svátků, dovolené
- Důvod blokování (volitelný)

## ⚙️ Nastavení

### Základní informace

- **Název provozovny** - Zobrazuje se v emailech
- **Email** - Pro příjem notifikací
- **Telefon** - Zobrazuje se v potvrzovacích emailech

### Rezervační parametry

- **Interval rezervací** - Časový interval mezi termíny (15-120 min)
- **Předstih rezervace** - Kolik dní dopředu lze rezervovat (7-365 dní)
- **Minimální předstih** - Minimální čas před termínem (1-168 hodin)

### Email notifikace

- **Povolit notifikace** - Zapnout/vypnout emailové notifikace
- **Notifikace administrátorovi** - Email při nové rezervaci
- **Notifikace zákazníkovi** - Potvrzovací email

### Formátování

- **Měna** - Výchozí: Kč
- **Formát data** - Výchozí: d.m.Y
- **Formát času** - Výchozí: H:i

## 🎨 Přizpůsobení

### CSS styly

Plugin používá CSS proměnné, které můžete přepsat:

```css
:root {
  --kr-primary: #f89820; /* Primární barva */
  --kr-secondary: #2d4a45; /* Sekundární barva */
  --kr-success: #22c55e; /* Barva úspěchu */
  --kr-error: #ef4444; /* Barva chyby */
}
```

### Email šablony

Email šablony lze upravit v souborech:

- `includes/class-kr-email.php`

## 🔧 Technické informace

### Požadavky

- WordPress 6.0+
- PHP 7.4+
- MySQL 5.6+

### Databázové tabulky

Plugin vytváří 4 tabulky:

1. **wp_kr_services** - Služby
2. **wp_kr_bookings** - Rezervace
3. **wp_kr_time_slots** - Časové sloty
4. **wp_kr_blocked_dates** - Blokovaná data

### AJAX endpointy

- `kr_get_services` - Načtení služeb
- `kr_get_available_dates` - Dostupné datumy
- `kr_get_available_times` - Dostupné časy
- `kr_create_booking` - Vytvoření rezervace
- `kr_update_booking_status` - Aktualizace statusu (admin)
- `kr_delete_booking` - Smazání rezervace (admin)

## 🐛 Řešení problémů

### Rezervace se neodešle

1. Zkontrolujte JavaScript konzoli pro chyby
2. Ověřte, že AJAX funguje (zkontrolujte Network tab)
3. Zkontrolujte PHP error log

### Emaily se neposílají

1. Ověřte nastavení SMTP serveru
2. Zkontrolujte spam složku
3. Použijte plugin pro SMTP (např. WP Mail SMTP)

### Kalendář nezobrazuje dostupné dny

1. Zkontrolujte nastavení pracovní doby
2. Ověřte, že služba má nastavenou dobu trvání
3. Zkontrolujte blokovaná data

## 📝 Changelog

### Version 1.0.0

- První vydání
- Základní rezervační systém
- Admin rozhraní
- Email notifikace
- Shortcode a Gutenberg blok

## 👥 Podpora

Pro podporu kontaktujte:

- Email: andersova.ji@gmail.com
- Web: https://www.test.rezervace-atelier.eu/

## 📄 Licence

GPL v2 or later

## 🙏 Poděkování

Děkujeme za použití našeho pluginu!

---

Vytvořeno s ❤️ pro české kadeřnictví
- Ověř, že soubor je opravdu na adrese:
https://www.test.rezervace-atelier.eu/seznam-umt-2sb8urjD9sur9HRcr9p7uIADs9rpT.txt

