// nastaveni-kalendar.js
// Modul: Nastaven kalende
// Autor: Jitka / ChatGPT
// el: Rozen vzhledu a chovn kalende (banner, legenda, vkend, font)
// Bez zsahu do jdra  doplnk k hlavnmu kalendi

jQuery(document).ready(function ($) {
    if (!$('.calendar-wrapper').length) return;

    // ? Lokalizovan nastaven z PHP
    const nastaveni = window.mrNastaveniKalendaru || {};

    // 1?? Stylovn  barvy a font
    if (nastaveni.barvy) {
        document.documentElement.style.setProperty('--hlavni-barva', nastaveni.barvy.volny || '#3a87ad');
    }
    if (nastaveni.font) {
        $('.calendar-wrapper').css('font-family', nastaveni.font);
    }

    // 2?? Zobrazen banneru
    if (nastaveni.banner) {
        if (!$('.calendar-wrapper .calendar-banner').length) {
            $('<div class="calendar-banner"></div>')
                .css({
                    'background-image': `url('${nastaveni.banner}')`,
                    'background-size': 'cover',
                    'background-position': 'center',
                    'height': '150px',
                    'margin-bottom': '15px'
                })
                .prependTo('.calendar-wrapper');
        }
    }

    // 3?? Legenda
    function zobrazLegendu() {
        if (!nastaveni.zobrazLegend) return;
        if ($('.calendar-wrapper .calendar-legend').length) return;

        const legenda = $(`
            <div class="calendar-legend">
                <h4>Legenda</h4>
                <ul>
                    <li><span style="background:${nastaveni.barvy?.volny || '#3a87ad'}"></span> Voln termny</li>
                    <li><span style="background:${nastaveni.barvy?.rezervovano || '#f0ad4e'}"></span> Rezervovan</li>
                    <li><span style="background:${nastaveni.barvy?.obsazeno || '#d9534f'}"></span> Obsazeno</li>
                </ul>
            </div>
        `);

        $('.calendar-wrapper').append(legenda);
    }

    // 4?? Skryt vkendu, pokud je vypnut
    function nastavZobrazeniVikendu() {
        if (nastaveni.zobrazWeekend === false) {
            $('.calendar-header .vikend, .calendar-day.vikend').hide();
        }
    }

    // 5?? Sputn funkc
    zobrazLegendu();
    nastavZobrazeniVikendu();
});
