<div class="nova-rezervace">

<?php
if (!defined('ABSPATH')) exit;

// Načtení nastavení z adminu
$calendar_color        = get_option('mr_calendar_color', '#3a87ad');
$calendar_font         = get_option('mr_calendar_font', 'Arial, sans-serif');
$calendar_banner       = get_option('mr_calendar_banner', '');
$calendar_show_legend  = get_option('mr_calendar_show_legend', 1);
$calendar_show_weekend = get_option('mr_calendar_show_weekend', 1);
$calendar_banner_title       = get_option('mr_calendar_banner_title', '');
$calendar_banner_title_color = get_option('mr_calendar_banner_title_color', '#ffffff');

// Připojení k DB pro načtení rezervací
global $wpdb;
$table_name = $wpdb->prefix . 'rezervace';
$rezervace = $wpdb->get_results("SELECT datum, cas, dostupnost FROM $table_name");

// Převod na pole pro rychlé vyhledávání
$dny = [];
foreach ($rezervace as $r) {
    $dny[$r->datum][$r->cas] = $r->dostupnost;
}

// Načtení funkcí z externího souboru
include __DIR__ . '/calendar-funkce.php';

// Určení banneru a vykreslení
$banner_to_show = cf_get_banner($calendar_banner, $calendar_color);
cf_render_banner($banner_to_show, $calendar_banner_title, $calendar_banner_title_color);
?>

    <!-- Navigace mezi měsíci -->
    <div class="calendar-nav">
        <button id="prev-month">←</button>
        <span id="month-label"></span>
        <button id="next-month">→</button>
    </div>

    <!-- Hlavička dnů -->
    <div class="calendar-header days-header">
        <div>PO</div><div>ÚT</div><div>ST</div><div>ČT</div><div>PÁ</div>
        <?php if ($calendar_show_weekend): ?>
            <div class="vikend">SO</div>
            <div class="vikend">NE</div>
        <?php endif; ?>
    </div>

    <!-- Kontejner pro kalendář a dostupné časy -->
    <div id="calendar" class="calendar-grid"></div>
    <div id="dostupne-casy"></div>

    <!-- Legenda -->
    <?php if ($calendar_show_legend): ?>
        <div class="calendar-legend">
          <h4>Legenda</h4>
          <ul style="list-style:none; padding:0; margin:0;">
            <li>
              <span style="display:inline-block;width:15px;height:15px;border-radius:50%;
                           background:lightskyblue;margin-right:6px;vertical-align:middle;"></span>
              Volné termíny
            </li>
            <li>
              <span style="display:inline-block;width:15px;height:15px;border-radius:50%;
                           background:lightblue;margin-right:6px;vertical-align:middle;"></span>
              Rezervované
            </li>
            <li>
              <span style="display:inline-block;width:15px;height:15px;border-radius:50%;
                           background:#cccccc;margin-right:6px;vertical-align:middle;"></span>
              Minulé dny
            </li>
          </ul>
        </div>
    <?php endif; ?>
</div>

<!-- Plovoucí formulář -->
    <div id="bs-notification" class="bs-notification"></div>
   <!-- Plovoucí formulář -->
<div id="rezervacni-formular" style="display:none;">
    <h3>Rezervace termínu</h3>
    <form id="nova-rezervace-formular">
        <p><strong>Datum:</strong> <span id="vybrany-datum-label"></span></p>
        <p><strong>Čas:</strong> <span id="vybrany-cas-label"></span></p>
        <input type="hidden" name="datum" id="datum-input">
        <input type="hidden" name="cas" id="cas-input">
        <input type="hidden" name="slot_id" id="slot-id-input">

        <label for="jmeno">Jméno:</label>
        <input type="text" name="jmeno" id="jmeno" required>

        <label for="email">Email:</label>
        <input type="email" name="email" id="email" required>

        <label for="mobil">Mobil:</label>
        <input type="tel" name="mobil" id="mobil" required>

        <label for="zprava">Zpráva (volitelná):</label>
        <textarea name="zprava" id="zprava" rows="3"></textarea>

        <!-- Odeslat rezervaci -->
        <button type="submit">Potvrdit rezervaci</button>

        <!-- Zavírací tlačítko jako součást formuláře -->
        <button type="button" id="close-form-btn-bottom"> Zavřít</button>

        <div id="rezervace-zprava"></div>
    </form>
</div>

    <!-- Plovoucí tlačítko pro otevření formuláře -->
    <button id="rezervace-btn">Rezervovat termín</button>

</div>

<script>
window.mrNastaveniKalendaru = <?php echo json_encode([
    'dateFormat' => $calendar_date_format,
    'timeFormat' => $calendar_time_format,
    'zobrazLegend'=> $calendar_show_legend ? true : false,
    'zobrazWeekend'=> $calendar_show_weekend ? true : false,
    'barvy' => [
        'volny' => $calendar_color,
        'obsazeno' => get_option('mr_color_obsazeno','#d9534f'),
        'rezervovano' => get_option('mr_color_rezervovano','#f0ad4e'),
    ],
    'font'=> $calendar_font,
    'banner'=> $calendar_banner,
    'autoOpen'=> $calendar_auto_open ? true : false,
    'view'=> $calendar_view
], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>;
</script>
