<?php
if (!defined('ABSPATH')) exit;

/**
 * Vrt banner (barvu nebo obrzek)
 */
if (!function_exists('cf_get_banner')) {
    function cf_get_banner($calendar_banner, $calendar_color) {
        return $calendar_banner ?: $calendar_color;
    }
}

/**
 * Vykresl banner s nadpisem
 */
if (!function_exists('cf_render_banner')) {
    function cf_render_banner($banner_to_show, $calendar_banner_title = '', $calendar_banner_title_color = '#ffffff') {
        if (!$banner_to_show) return;

        if (preg_match('/^#([A-Fa-f0-9]{3,6})$/', $banner_to_show)) {
            // Banner je barva
            echo '<div class="calendar-banner" style="background-color: '.esc_attr($banner_to_show).'; height:150px; position:relative;">';
        } else {
            // Banner je obrzek
            echo '<div class="calendar-banner" style="background-image: url(\''.esc_url($banner_to_show).'\'); background-size: cover; background-position: center; height:150px; position:relative;">';
        }

        if ($calendar_banner_title) {
            echo '<h2 style="position:absolute; top:50%; left:50%; transform:translate(-50%,-50%); margin:0; color:'.esc_attr($calendar_banner_title_color).';">'
                .esc_html($calendar_banner_title).
                '</h2>';
        }

        echo '</div>';
    }
}