jQuery(document).ready(function($) {
    const nastaveni = window.mrNastaveniKalendaru || {};

    // 1️⃣ Stylování
    if (nastaveni.barvy) {
        document.documentElement.style.setProperty('--hlavni-barva', nastaveni.barvy.volny || '#3a87ad');
    }
    if (nastaveni.font) {
        $('.calendar-wrapper').css('font-family', nastaveni.font);
    }

    // 2️⃣ Legenda
    function zobrazLegendu() {
        if (!nastaveni.zobrazLegend) return;
        const container = $('#calendar-legend-container');
        if (!container.length || container.children().length) return;

        const legenda = $(`
            <div class="calendar-legend">
                <h4>Legenda</h4>
                <ul>
                    <li><span style="background:${nastaveni.barvy?.volny || '#3a87ad'}"></span> Volné termíny</li>
                    <li><span style="background:${nastaveni.barvy?.rezervovano || '#f0ad4e'}"></span> Rezervované</li>
                    <li><span style="background:${nastaveni.barvy?.obsazeno || '#d9534f'}"></span> Obsazeno</li>
                </ul>
            </div>
        `);
        container.append(legenda);
    }

    // 3️⃣ Skrytí víkendů
    function nastavVikendy() {
        if (nastaveni.zobrazWeekend === false) {
            $('.calendar-header .vikend, .calendar-day.vikend').hide();
        }
    }

    // 4️⃣ Přepínání zobrazení
    function nastavZobrazeni() {
        const view = nastaveni.view || 'month';
        $('body').attr('data-calendar-view', view);

        if (!$('.calendar-view-switch').length) {
            const switcher = $(`
                <div class="calendar-view-switch">
                    <button data-view="month">Měsíc</button>
                    <button data-view="week">Týden</button>
                    <button data-view="day">Den</button>
                </div>
            `);
            $('.calendar-nav').after(switcher);

            switcher.find('button').on('click', function() {
                const newView = $(this).data('view');
                $('body').attr('data-calendar-view', newView);
                switcher.find('button').removeClass('active');
                $(this).addClass('active');
            });

            switcher.find(`[data-view="${view}"]`).addClass('active');
        }
    }

    // 5️⃣ Automatické otevření nejbližšího volného dne
    function autoOpen() {
        if (!nastaveni.autoOpen) return;
        if (typeof zobrazCasyProDen !== 'function') return;

        fetch('/wp-json/rezervace/v1/volne-dny')
            .then(res => res.json())
            .then(dny => {
                if (Array.isArray(dny) && dny.length) {
                    zobrazCasyProDen(dny[0]);
                }
            }).catch(err => console.warn('Auto-open selhalo:', err));
    }

    // 🔵 Spuštění funkcí
    zobrazLegendu();
    nastavVikendy();
    nastavZobrazeni();
    autoOpen();
});
