<?php
if (!defined('ABSPATH')) exit;

global $wpdb;
$table = $wpdb->prefix . 'rezervace';

// ------------------------------------------------------
// Funkce pro uloen rezervace
// ------------------------------------------------------
function mr_uloz_rezervaci($data) {
    global $wpdb;
    $table = $wpdb->prefix . 'rezervace';

    // Sanitizace vstup
    $datum  = sanitize_text_field($data['datum'] ?? '');
    $cas    = sanitize_text_field($data['cas'] ?? '');
    $typ    = sanitize_text_field($data['typ'] ?? 'jednotlive');
    $jmeno  = sanitize_text_field($data['jmeno'] ?? '');
    $email  = sanitize_email($data['email'] ?? '');
    $mobil  = sanitize_text_field($data['mobil'] ?? '');
    $zprava = sanitize_textarea_field($data['zprava'] ?? '');

    // Zkontrolujeme, zda slot nen ji obsazen
    $exists = $wpdb->get_var($wpdb->prepare(
        "SELECT COUNT(*) FROM $table WHERE datum = %s AND cas = %s",
        $datum, $cas
    ));

    if($exists > 0){
        return ['success' => false, 'message' => 'Tento as je ji obsazen.'];
    }

    // Vloen do DB
    $inserted = $wpdb->insert($table, [
        'datum'  => $datum,
        'cas'    => $cas,
        'typ'    => $typ,
        'jmeno'  => $jmeno,
        'email'  => $email,
        'mobil'  => $mobil,
        'zprava' => $zprava,
        'potvrzeno' => 0
    ], [
        '%s','%s','%s','%s','%s','%s','%d'
    ]);

    if(!$inserted){
        return ['success' => false, 'message' => 'Chyba pi ukldn rezervace.'];
    }

    $reservation = (object)[
        'datum'  => $datum,
        'cas'    => $cas,
        'typ'    => $typ,
        'jmeno'  => $jmeno,
        'email'  => $email,
        'mobil'  => $mobil,
        'zprava' => $zprava
    ];

    // Odesln e-mailu klientovi
    if(function_exists('mr_posli_potvrzeni')){
        mr_posli_potvrzeni($reservation);
    }

    // Odesln e-mailu adminovi
    $admin_email = get_option('from_email', get_option('admin_email'));
    if(function_exists('mr_posli_email')){
        $body_admin = mr_nacti_sablonu('rezervace.txt', [
            'datum'  => $datum,
            'cas'    => $cas,
            'jmeno'  => $jmeno,
            'email'  => $email,
            'mobil'  => $mobil,
            'zprava' => $zprava
        ]);
        mr_posli_email($admin_email, 'Nov rezervace', $body_admin);
    }

    return ['success' => true, 'message' => 'Rezervace byla spn uloena.'];
}
