<?php
if (!defined('ABSPATH')) exit;

// 🔧 Vytvoření tabulky rezervace při aktivaci pluginu
function bs_create_rezervace_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'rezervace';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
        datum DATE NOT NULL,
        cas TIME NOT NULL,
        typ VARCHAR(20) NOT NULL DEFAULT 'jednoduchy',
        dostupnost VARCHAR(20) NOT NULL DEFAULT 'volny',
        jmeno VARCHAR(100) DEFAULT '',
        email VARCHAR(100) DEFAULT '',
        mobil VARCHAR(50) DEFAULT '',
        zprava TEXT,
        potvrzeno TINYINT(1) DEFAULT 0,
        PRIMARY KEY (id),
        UNIQUE KEY unique_slot (datum, cas)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'bs_create_rezervace_table');

// Shortcode pro kalendář
function nova_rezervace_calendar_shortcode() {
    ob_start();
    $calendar_template = plugin_dir_path(__FILE__) . '../templates/calendar.php';
    if (file_exists($calendar_template)) include $calendar_template;
    else echo '<p>Kalendář není dostupný.</p>';
    return ob_get_clean();
}
add_shortcode('nova_rezervace_kalendar', 'nova_rezervace_calendar_shortcode');

// Odeslání testovacího e-mailu (frontend/admin)
if (isset($_POST['send_test_email']) && function_exists('mr_posli_email')) {
    $to = get_option('from_email');
    $subject = 'Testovací e-mail';
    $message = '<p>Toto je testovací e-mail ze systému rezervací.</p>';
    if (mr_posli_email($to, $subject, $message)) {
        echo '<div class="updated"><p>Testovací e-mail byl odeslán na '.$to.'</p></div>';
    } else {
        echo '<div class="error"><p>Odeslání testovacího e-mailu se nezdařilo.</p></div>';
    }
}
