<?php
if (!defined('ABSPATH')) exit;

global $wpdb;
$table = $wpdb->prefix . 'rezervace';

// ------------------------------
// Funkce pro načtení šablony
// ------------------------------
function mr_nacist_sablonu($soubor, $data = []) {
    $slozka = plugin_dir_path(dirname(__FILE__)) . 'admin/email/';
    $text = file_get_contents($slozka . $soubor);
    if (!$text) return '';

    foreach ($data as $klic => $hodnota) {
        $text = str_replace('{{' . $klic . '}}', $hodnota, $text);
    }

    return $text;
}

// ------------------------------
// Uložení rezervace
// ------------------------------
add_action('wp_ajax_bs_ulozit_rezervaci', 'mr_ulozit_rezervaci');
add_action('wp_ajax_nopriv_bs_ulozit_rezervaci', 'mr_ulozit_rezervaci');

function mr_ulozit_rezervaci() {
    global $wpdb;
    $table = $wpdb->prefix . 'rezervace';

    // Ověření nonce
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'mr_nonce')) {
        wp_send_json_error(['zprava' => 'Neplatný požadavek']);
    }

    $data = $_POST;

    // Kontrola, zda jsou datum a čas vyplněny
    if (!empty($data['datum']) && !empty($data['cas'])) {

        $exists = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM $table WHERE datum=%s AND cas=%s AND dostupnost='volny'",
            $data['datum'], $data['cas']
        ));

        if ($exists) {
            // Aktualizace rezervace
            $wpdb->update(
                $table,
                [
                    'dostupnost' => 'obsazeno',
                    'jmeno'      => sanitize_text_field($data['jmeno']),
                    'email'      => sanitize_email($data['email']),
                    'mobil'      => sanitize_text_field($data['mobil']),
                    'zprava'     => sanitize_textarea_field($data['zprava']),
                    'potvrzeno'  => 1
                ],
                [
                    'datum' => $data['datum'],
                    'cas'   => $data['cas']
                ]
            );

            // Odeslání e-mailů, pokud funkce existuje
            if (function_exists('mr_posli_email')) {

                // E-mail klientovi
                $body = mr_nacist_sablonu('rezervacni-formular.html', [
                    'jmeno'    => sanitize_text_field($data['jmeno']),
                    'datum'    => sanitize_text_field($data['datum']),
                    'cas'      => sanitize_text_field($data['cas']),
                    'mobil'    => sanitize_text_field($data['mobil']),
                    'poznamka' => sanitize_textarea_field($data['zprava']),
                ]);
                mr_posli_email(sanitize_email($data['email']), 'Potvrzení rezervace', $body);

                // E-mail administrátorovi
                $admin_email = sanitize_email(get_option('from_email'));
                $body_admin = mr_nacist_sablonu('rezervace.html', [
                    'jmeno'    => sanitize_text_field($data['jmeno']),
                    'email'    => sanitize_email($data['email']),
                    'mobil'    => sanitize_text_field($data['mobil']),
                    'datum'    => sanitize_text_field($data['datum']),
                    'cas'      => sanitize_text_field($data['cas']),
                    'poznamka' => sanitize_textarea_field($data['zprava']),
                ]);
                mr_posli_email($admin_email, 'Nová rezervace', $body_admin);
            }

            // Úspěšná odpověď AJAX
            wp_send_json_success(['zprava' => '✅ Rezervace byla potvrzena']);
        } else {
            // Čas už je obsazen
            wp_send_json_error(['zprava' => '❌ Tento čas je již obsazen']);
        }

    } else {
        // Neplatná data
        wp_send_json_error(['zprava' => '❌ Neplatná data']);
    }
}

// ------------------------------
// Načtení slotů pro kalendář
// ------------------------------
add_action('wp_ajax_bs_get_slots', 'bs_get_slots');
add_action('wp_ajax_nopriv_bs_get_slots', 'bs_get_slots');

function bs_get_slots() {
    global $wpdb;
    $table = $wpdb->prefix . 'rezervace';

    $month = isset($_GET['month']) ? intval($_GET['month']) : date('n');
    $year  = isset($_GET['year']) ? intval($_GET['year']) : date('Y');

    $slots = $wpdb->get_results($wpdb->prepare(
        "SELECT datum, cas, typ, dostupnost FROM $table WHERE YEAR(datum)=%d AND MONTH(datum)=%d",
        $year, $month
    ));

    $data = [];
    $days_free_count = [];

    if($slots){
        foreach($slots as $r){
            $data[] = [
                'datum' => $r->datum,
                'cas'   => $r->cas,
                'typ'   => $r->typ,
                'stav'  => $r->dostupnost
            ];
            if($r->dostupnost === 'volny'){
                if(!isset($days_free_count[$r->datum])) $days_free_count[$r->datum] = 0;
                $days_free_count[$r->datum]++;
            }
        }
    }

    wp_send_json(['slots' => $data, 'days_free_count' => $days_free_count]);
}

// ------------------------------
// Testovací e-mail
// ------------------------------
add_action('wp_ajax_mr_send_test_email', function() {
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'mr_nonce')) {
        wp_send_json_error('❌ Chybný bezpečnostní token (nonce).');
    }

    if (!function_exists('mr_posli_email')) {
        wp_send_json_error('❌ Funkce pro odesílání e-mailů není dostupná.');
    }

    $to      = get_option('from_email');
    $subject = 'Testovací e-mail ze systému rezervací';
    $message = '<p>Tento e-mail slouží k otestování SMTP nastavení.</p>';
    $message .= '<p>Datum a čas: ' . date('Y-m-d H:i:s') . '</p>';

    $sent = mr_posli_email($to, $subject, $message);

    if ($sent) {
        wp_send_json_success('✅ Testovací e-mail byl odeslán na: ' . esc_html($to));
    } else {
        wp_send_json_error('❌ Odeslání testovacího e-mailu selhalo. Zkontrolujte SMTP nastavení a logy.');
    }
});


if (!defined('ABSPATH')) exit;

add_action('wp_ajax_mr_uloz_rezervaci', 'mr_ajax_uloz_rezervaci');
add_action('wp_ajax_nopriv_mr_uloz_rezervaci', 'mr_ajax_uloz_rezervaci');

function mr_ajax_uloz_rezervaci() {
    check_ajax_referer('mr_nonce', 'nonce');

    if (!function_exists('mr_uloz_rezervaci')) {
        wp_send_json(['success' => false, 'message' => 'Funkce pro uložení rezervace není dostupná.']);
    }

    $response = mr_uloz_rezervaci($_POST);
    wp_send_json($response);
}
// -------------------------------
// AJAX handler pro mazání rezervace
// -------------------------------
add_action('wp_ajax_bs_delete_reservation', 'bs_delete_reservation');
function bs_delete_reservation(){
    check_ajax_referer('bs_delete_reservation');
    global $wpdb;
    $table = $wpdb->prefix . 'rezervace';
    $id = intval($_POST['id'] ?? 0);

    if($id > 0){
        $wpdb->delete($table, ['id'=>$id]);
        wp_send_json_success(['message'=>'Rezervace smazána.']);
    }
    wp_send_json_error(['message'=>'Nepodařilo se smazat.']);
}

add_action('wp_ajax_mr_save_email_settings', function(){
    check_ajax_referer('mr_nonce','nonce');

    if(!current_user_can('manage_options')){
        wp_send_json_error('Unauthorized');
    }

    $options = [
        'from_name' => sanitize_text_field($_POST['from_name']),
        'from_email' => sanitize_email($_POST['from_email']),
        'smtp_host' => sanitize_text_field($_POST['smtp_host']),
        'smtp_port' => intval($_POST['smtp_port']),
        'smtp_user' => sanitize_text_field($_POST['smtp_user']),
        'smtp_pass' => sanitize_text_field($_POST['smtp_pass']),
        'smtp_secure' => sanitize_text_field($_POST['smtp_secure']),
    ];

    foreach($options as $key => $value){
        update_option($key, $value);
    }

    wp_send_json_success('✅ Nastavení pošty bylo uloženo.');
});

