// JavaScript Document

jQuery(document).ready(function($) {

  const config = window.mrNastaveniKalendaru || {};

  // 🕒 Zobrazení dostupných časů pro vybraný den
  function zobrazCasyProDen(den) {
    const wrapper = document.getElementById('dostupne-casy');
    wrapper.innerHTML = '';

    const aktualniDatum = new Date();
    const mesic = aktualniDatum.getMonth() + 1;
    const rok = aktualniDatum.getFullYear();

    fetch(`/wp-json/rezervace/v1/casy?den=${den}&mesic=${mesic}&rok=${rok}`)
      .then(res => res.json())
      .then(casy => {
        if (casy.length === 0) {
          wrapper.innerHTML = '<p class="ajax-zprava">Žádné dostupné časy.</p>';
          return;
        }

        casy.forEach(cas => {
          const btn = document.createElement('button');
          btn.textContent = (config.timeFormat === '12h') ? prevedNa12h(cas) : cas;
          btn.classList.add('cas-button');

          btn.addEventListener('click', () => {
            document.querySelectorAll('.cas-button').forEach(b => b.classList.remove('active'));
            btn.classList.add('active');
            zobrazFormular(den, cas);
          });

          wrapper.appendChild(btn);
        });

        // 🔁 Auto otevřít první volný čas (pokud je nastaveno)
        if (config.autoOpen && casy.length > 0) {
          const prvni = wrapper.querySelector('.cas-button');
          if (prvni) {
            prvni.click();
          }
        }
      })
      .catch(err => {
        wrapper.innerHTML = `<p class="ajax-zprava error">Nepodařilo se načíst dostupné časy.</p>`;
        console.error(err);
      });
  }

  // 🧮 Převod času do 12h formátu
  function prevedNa12h(cas) {
    if (!cas.includes(':')) return cas;
    let [h, m] = cas.split(':');
    let hod = parseInt(h, 10);
    const ampm = hod >= 12 ? 'PM' : 'AM';
    hod = (hod % 12) || 12;
    return `${hod}:${m} ${ampm}`;
  }

  // 🧾 Zobrazení formuláře pro rezervaci
  function zobrazFormular(den, cas) {
    const wrapper = document.getElementById('dostupne-casy');
    wrapper.innerHTML = '';

    const formular = document.createElement('form');
    formular.classList.add('rezervacni-formular');

    formular.innerHTML = `
      <h3>Rezervace na ${den}. den v ${cas}</h3>
      <label>Jméno:<br><input type="text" name="jmeno" required></label><br>
      <label>Mobil:<br><input type="tel" name="mobil" required></label><br>
      <label>Email:<br><input type="email" name="email" required></label><br>
      <label>Poznámka:<br><textarea name="poznamka"></textarea></label><br>
      <button type="submit">Odeslat rezervaci</button>
    `;

    formular.addEventListener('submit', e => {
      e.preventDefault();

      const data = {
        action: 'ulozit_rezervaci',
        den: den,
        cas: cas,
        jmeno: formular.jmeno.value,
        mobil: formular.mobil.value,
        email: formular.email.value,
        poznamka: formular.poznamka.value
      };

      fetch('/wp-admin/admin-ajax.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams(data)
      })
      .then(res => res.json())
      .then(response => {
        wrapper.innerHTML = `<p class="ajax-zprava">${response.zprava}</p>`;
      })
      .catch(err => {
        wrapper.innerHTML = `<p class="ajax-zprava error">Chyba při odesílání rezervace.</p>`;
        console.error(err);
      });
    });

    wrapper.appendChild(formular);
  }

  // 🧭 Inicializace kalendáře
  function inicializujKalendar() {
    // Skrytí víkendů
    if (!config.zobrazWeekend) {
      $('.vikend').hide();
    }

    // Zobrazení banneru
    if (config.banner) {
      const wrapper = document.querySelector('.calendar-wrapper');
      if (wrapper && !wrapper.querySelector('.calendar-banner')) {
        const bannerDiv = document.createElement('div');
        bannerDiv.classList.add('calendar-banner');
        bannerDiv.style.backgroundImage = `url('${config.banner}')`;
        bannerDiv.style.height = '150px';
        bannerDiv.style.backgroundSize = 'cover';
        wrapper.prepend(bannerDiv);
      }
    }

    // Vytvoření legendy
    if (config.zobrazLegend && !document.querySelector('.calendar-legenda')) {
      const legenda = document.createElement('div');
      legenda.classList.add('calendar-legenda');
      legenda.innerHTML = `
        <span style="background:${config.barvy?.volny || '#3a87ad'}">Volné</span>
        <span style="background:${config.barvy?.obsazeno || '#d9534f'}">Obsazeno</span>
        <span style="background:${config.barvy?.rezervovano || '#f0ad4e'}">Rezervováno</span>
      `;
      document.querySelector('.calendar-wrapper')?.appendChild(legenda);
    }
  }

  inicializujKalendar();

});
