// JavaScript Document
// assets/notifications.js
function showNotification(message, type = "info") {
    const notif = document.getElementById("bs-notification");
    if (!notif) return;

    notif.textContent = message;
    notif.className = "bs-notification " + type;
    notif.classList.add("show");

    setTimeout(() => {
        notif.classList.remove("show");
    }, 3000);
}
(function() {
    if (typeof showNotification !== 'function') {
        console.warn('showNotification nen dostupn  alerty zstanou klasick.');
        return;
    }

    window.alert = function(message) {
        let type = 'error'; // default erven

        const msg = message.toLowerCase();

        // Explicitn success podmnky
        if (
            (msg.includes('email') && msg.includes('odesln')) ||
            msg.includes('uloeno') ||
            msg.includes('rezervace byla vytvoena') ||
            msg.includes('provedeno') ||
            msg.includes('spch')
        ) {
            type = 'success'; // zelen bublina
        }

        // Explicitn error podmnky
        if (
            msg.includes('chyba') ||
            msg.includes('nepodailo') ||
            msg.includes('neexistuje') ||
            msg.includes('smazno') ||
            msg.includes('zrueno')
        ) {
            type = 'error'; // erven bublina
        }

        showNotification(message, type, 3000);
    };
})();
