// JavaScript Document
// notifications.js

document.addEventListener('DOMContentLoaded', function() {

    // -----------------------------
    // Tooltipy (desktop hover + mobil tap)
    // -----------------------------
    const tooltips = document.querySelectorAll('.help-icon, .mr-tooltip-icon');

    tooltips.forEach(icon => {

        // Desktop hover
        icon.addEventListener('mouseenter', () => {
            const tip = icon.querySelector('.mr-tooltip-text') || icon.nextElementSibling;
            if(tip) tip.style.opacity = 1;
        });

        icon.addEventListener('mouseleave', () => {
            const tip = icon.querySelector('.mr-tooltip-text') || icon.nextElementSibling;
            if(tip) tip.style.opacity = 0;
        });

        // Mobiln tap / kliknut
        icon.addEventListener('click', (e) => {
            e.stopPropagation();
            const tip = icon.querySelector('.mr-tooltip-text') || icon.nextElementSibling;
            if(!tip) return;
            if(tip.style.opacity == 1) {
                tip.style.opacity = 0;
            } else {
                // Schovat vechny ostatn
                document.querySelectorAll('.mr-tooltip-text').forEach(t => t.style.opacity = 0);
                tip.style.opacity = 1;
            }
        });

    });

    // Kliknut mimo tooltip zave vechny
    document.addEventListener('click', () => {
        document.querySelectorAll('.mr-tooltip-text').forEach(t => t.style.opacity = 0);
    });

    // -----------------------------
    // Notifikace / bubliny
    // -----------------------------
    window.showNotification = function(message, type = "success", duration = 3000) {
        const notif = document.createElement('div');
        notif.className = `mr-notification ${type}`;
        notif.textContent = message;

        // Pidat do body
        document.body.appendChild(notif);

        // Mal prodleva pro animaci
        setTimeout(() => {
            notif.classList.add('show');
        }, 50);

        // Automatick skryt po duration
        setTimeout(() => {
            notif.classList.remove('show');
            setTimeout(() => document.body.removeChild(notif), 300);
        }, duration);
    };

});

(function() {
    if (typeof showNotification !== 'function') {
        console.warn('showNotification nen dostupn  alerty zstanou klasick.');
        return;
    }

    window.alert = function(message) {
        let type = 'error'; // default erven

        const msg = message.toLowerCase();

        // Explicitn success podmnky
        if (
            (msg.includes('email') && msg.includes('odesln')) ||
            msg.includes('uloeno') ||
            msg.includes('rezervace byla vytvoena') ||
            msg.includes('provedeno') ||
            msg.includes('spch')
        ) {
            type = 'success'; // zelen bublina
        }

        // Explicitn error podmnky
        if (
            msg.includes('chyba') ||
            msg.includes('nepodailo') ||
            msg.includes('neexistuje') ||
            msg.includes('smazno') ||
            msg.includes('zrueno')
        ) {
            type = 'error'; // erven bublina
        }

        showNotification(message, type, 3000);
    };
})();
