document.addEventListener('DOMContentLoaded', () => {
  const rezervacniFormular = document.getElementById('rezervacni-formular');
  const tlacitko = document.getElementById('rezervace-btn');
  const closeBtn = document.getElementById('close-form-btn-bottom');

  // -------------------------
  // Plovoucí tlačítko pro mobil
  // -------------------------
  if (tlacitko && rezervacniFormular) {
    tlacitko.addEventListener('click', () => {
      rezervacniFormular.style.display =
        (rezervacniFormular.style.display === 'none' || rezervacniFormular.style.display === '') ? 'block' : 'none';
    });
  }

  // -------------------------
  // Odeslání formuláře AJAXem
  // -------------------------
  if (rezervacniFormular) {
    rezervacniFormular.addEventListener('submit', (e) => {
      e.preventDefault();

      const formData = new FormData(rezervacniFormular);
      formData.append('action', 'mr_uloz_rezervaci');
      formData.append('nonce', bs_ajax.nonce);

      fetch(bs_ajax.url, {
        method: 'POST',
        body: formData
      })
      .then(res => res.json())
      .then(data => {
        if (data.success) {
          alert(data.message);
          rezervacniFormular.reset();
          rezervacniFormular.style.display = 'none';
        } else {
          alert(data.message);
        }
      })
      .catch(err => {
        console.error(err);
        alert('Chyba při odesílání rezervace.');
      });
    });
  }

  // -------------------------
  // Zavření přes spodní X tlačítko
  // -------------------------
  if (closeBtn) {
    closeBtn.addEventListener('click', () => {
      rezervacniFormular.style.display = 'none';
    });
  }
});
