document.addEventListener('DOMContentLoaded', () => {
  const calendarEl = document.getElementById('calendar');
  const monthLabel = document.getElementById('month-label');
  const dostupneCasy = document.getElementById('dostupne-casy');
  const rezervacniFormular = document.getElementById('rezervacni-formular');
  const vybranyDatumLabel = document.getElementById('vybrany-datum-label');
  const vybranyCasLabel = document.getElementById('vybrany-cas-label');
  const datumInput = document.getElementById('datum-input');
  const casInput = document.getElementById('cas-input');

  const monthNames = ['Leden','Únor','Březen','Duben','Květen','Červen','Červenec','Srpen','Září','Říjen','Listopad','Prosinec'];

  let today = new Date();
  let currentMonth = today.getMonth();
  let currentYear = today.getFullYear();

  function formatDate(date){
    const y = date.getFullYear();
    const m = ('0'+(date.getMonth()+1)).slice(-2);
    const d = ('0'+date.getDate()).slice(-2);
    return `${y}-${m}-${d}`;
  }

  function renderCalendar(month, year, reservations=[], daysFree={}){
    calendarEl.innerHTML = '';
    monthLabel.textContent = monthNames[month] + ' ' + year;

    const firstDay = new Date(year, month, 1);
    const lastDay = new Date(year, month + 1, 0);
    const startDay = firstDay.getDay() === 0 ? 6 : firstDay.getDay() - 1;
    const totalDays = lastDay.getDate();

    for(let i=0;i<startDay;i++) calendarEl.appendChild(document.createElement('div'));

    for(let d=1; d<=totalDays; d++){
      const dayEl = document.createElement('div');
      dayEl.textContent = d;
      dayEl.classList.add('calendar-day');

      const dayDate = new Date(year, month, d);
      const dayStr = formatDate(dayDate);

      dayEl.dataset.datum = dayStr;

      if(dayDate < new Date(new Date().setHours(0,0,0,0))) dayEl.classList.add('minuly-den');
      if(dayDate.getDay()===0 || dayDate.getDay()===6) dayEl.classList.add('vikend');

      const slotForDay = reservations.filter(r=>r.datum===dayStr);
      if(slotForDay.length){
        dayEl.classList.add('rezervovatelny-den');
        if(!daysFree[dayStr]){
          dayEl.classList.add('obsazeno');
          dayEl.style.pointerEvents = 'none';
          dayEl.style.opacity = '0.5';
        } else {
          dayEl.addEventListener('click', ()=>loadTimes(slotForDay));
        }
      } else if(!dayEl.classList.contains('minuly-den')){
        dayEl.classList.add('nerezervovatelny-den');
      }
      calendarEl.appendChild(dayEl);
    }

    if (window.mrNastaveniKalendaru && typeof window.mrFormatKalendaru === 'function') {
      window.mrFormatKalendaru();
    }
  }

  function loadTimes(slots){
    dostupneCasy.innerHTML = '';
    if(!slots || slots.length===0){
      dostupneCasy.innerHTML='<p>❌ Žádné volné časy.</p>';
      return;
    }
    const ul = document.createElement('ul');
    ul.style.listStyle = 'none';
    ul.style.padding = '0';
    ul.style.display = 'flex';
    ul.style.flexWrap = 'wrap';
    ul.style.gap = '0.5em';
    ul.style.justifyContent = 'center';

    slots.forEach(slot => {
      const li = document.createElement('li');
      const btn = document.createElement('button');
      
      btn.textContent = slot.cas || '???';

      btn.dataset.datum = slot.datum;
      btn.dataset.cas = slot.cas;

      if(slot.stav === 'volny'){
        btn.classList.add('slot-jednoduchy');
        btn.addEventListener('click', () => {
          vybranyDatumLabel.textContent = slot.datum;
          vybranyCasLabel.textContent = slot.cas;
          datumInput.value = slot.datum;
          casInput.value = slot.cas;
          rezervacniFormular.style.display = 'block';
        });
      } else {
        btn.classList.add('obsazeny-slot');
        btn.disabled = true;
        btn.style.backgroundColor = '#ccc';
        btn.style.cursor = 'not-allowed';
      }

      li.appendChild(btn);
      ul.appendChild(li);
    });

    dostupneCasy.appendChild(ul);

    if (window.mrNastaveniKalendaru && typeof window.mrFormatKalendaru === 'function') {
      window.mrFormatKalendaru();
    }
  }

  function fetchReservations(month = currentMonth, year = currentYear){
    return fetch(`${bs_ajax.url}?action=bs_get_slots&month=${month+1}&year=${year}`)
      .then(res => res.json());
  }

  function fetchReservationsAndRender(){
    fetchReservations()
      .then(data => renderCalendar(currentMonth, currentYear, data.slots, data.days_free_count))
      .catch(()=>renderCalendar(currentMonth, currentYear));
  }

  function fetchSlotsForDay(day){
    fetch(`${bs_ajax.url}?action=bs_get_slots&month=${currentMonth+1}&year=${currentYear}`)
      .then(res => res.json())
      .then(data => {
        const slotsForDay = data.slots.filter(s => s.datum === day);
        loadTimes(slotsForDay);
      });
  }

  // ⭐ BEZPEČNÁ VERZE – zachováno, ale ošetřeno
  const prevBtn = document.getElementById('prev-month');
  if (prevBtn) {
    prevBtn.addEventListener('click', () => {
      currentMonth--; 
      if (currentMonth < 0) { currentMonth = 11; currentYear--; }
      fetchReservationsAndRender();
    });
  }

  const nextBtn = document.getElementById('next-month');
  if (nextBtn) {
    nextBtn.addEventListener('click', () => {
      currentMonth++; 
      if (currentMonth > 11) { currentMonth = 0; currentYear++; }
      fetchReservationsAndRender();
    });
  }

  const novaRezForm = document.getElementById('nova-rezervace-formular');
  if (novaRezForm) {
    novaRezForm.addEventListener('submit', e => {
      e.preventDefault();
      const formData = new FormData(e.target);
      formData.append('action','bs_ulozit_rezervaci');
      formData.append('nonce',bs_ajax.nonce);

      const vybranyDen = datumInput.value;

      fetch(bs_ajax.url,{method:'POST',body:formData})
        .then(res=>res.json())
        .then(data=>{
          alert(data.data?.zprava || 'Rezervace odeslána');
          rezervacniFormular.style.display='none';
          fetchReservationsAndRender();
          if(vybranyDen) fetchSlotsForDay(vybranyDen);
        }).catch(err=>console.error(err));
    });
  }

  fetchReservationsAndRender();
});
