// JavaScript Document

document.addEventListener('DOMContentLoaded', function () {
  const calendarEl = document.getElementById('admin-calendar');

  if (!calendarEl) return;

  const calendar = new FullCalendar.Calendar(calendarEl, {
    initialView: 'dayGridMonth',
    events: '/wp-json/nova/v1/admin-rezervace', // endpoint pro admin přehled
    eventDidMount: function (info) {
      // Barevné odlišení podle typu rezervace
      if (info.event.extendedProps.typ === 'hromadna') {
        info.el.style.backgroundColor = '#ffcc00';
      } else if (info.event.extendedProps.typ === 'vicecasu') {
        info.el.style.backgroundColor = '#66ccff';
      } else {
        info.el.style.backgroundColor = '#99ff99';
      }
    },
    eventClick: function (info) {
      // Zobrazit detail rezervace (ne úprava)
      showReservationDetails(info.event);
    }
  });

  calendar.render();
});

function showReservationDetails(event) {
  // Zobrazit modal nebo tooltip s informacemi
  console.log('Detail rezervace:', event);
}

jQuery(document).ready(function($){
    // Mazání rezervace
    $('.delete-btn').on('click', function(){
        if(!confirm('Opravdu smazat rezervaci?')) return;
        const id = $(this).data('id');
        $.post(ajaxurl, { action: 'bs_delete_reservation', id: id }, function(res){
            alert(res.message);
            $('#reservation-' + id).fadeOut();
        });
    });

    // Odeslání e-mailu
    $('.email-btn').on('click', function(){
        const id = $(this).data('id');
        $.post(ajaxurl, { action: 'bs_send_reservation_email', id: id }, function(res){
            alert(res.message);
        });
    });
});

function bs_enqueue_admin_assets($hook) {
    if (strpos($hook, 'bs_admin') === false) return;
    wp_enqueue_style('bs-admin-style', plugins_url('assets/admin-style.css', __FILE__));
    wp_enqueue_script('bs-tabs', plugins_url('tabs.js', __FILE__), [], false, true);
}
add_action('admin_enqueue_scripts', 'bs_enqueue_admin_assets');
