<?php
global $wpdb;
$table_name = $wpdb->prefix . 'rezervace';

if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap">
    <?php
    // Zpracování formuláře pro přidání termínu
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['slot_date'], $_POST['slot_time'])) {
        check_admin_referer('slot_nonce', 'slot_nonce_field');

        $datum = sanitize_text_field($_POST['slot_date']);
        $cas   = sanitize_text_field($_POST['slot_time']);

        // Kontrola duplicity
        $existuje = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM $table_name WHERE datum = %s AND cas = %s",
            $datum, $cas
        ));

        if ($existuje == 0) {
            $wpdb->insert($table_name, [
                'datum' => $datum,
                'cas' => $cas,
                'typ' => 'jednoduchy',
                'dostupnost' => 'volny',
                'jmeno' => '',
                'email' => '',
                'mobil' => '',
                'zprava' => '',
                'potvrzeno' => 0
            ]);
            echo '<div class="updated"><p>✅ ' . sprintf(__('Termín byl přidán: %s – %s', 'nova-rezervace'), esc_html($datum), esc_html($cas)) . '</p></div>';
        } else {
            echo '<div class="error"><p>⚠️ ' . __('Tento termín už existuje.', 'nova-rezervace') . '</p></div>';
        }
    }
    ?>

    <h2><?php _e('Přidat dostupný termín', 'nova-rezervace'); ?></h2>
    <form method="post">
        <?php wp_nonce_field('slot_nonce', 'slot_nonce_field'); ?>
        <table class="form-table">
            <tr>
                <th><label for="slot-date"><?php _e('Datum', 'nova-rezervace'); ?></label></th>
                <td><input type="date" id="slot-date" name="slot_date" required></td>
            </tr>
            <tr>
                <th><label for="slot-time"><?php _e('Čas', 'nova-rezervace'); ?></label></th>
                <td><input type="time" id="slot-time" name="slot_time" required></td>
            </tr>
        </table>
        <p><button type="submit" class="button button-primary"><?php _e('Přidat do kalendáře', 'nova-rezervace'); ?></button></p>
    </form>

    <hr>

    <h3><?php _e('Dostupné termíny', 'nova-rezervace'); ?></h3>
    <?php
    $slots = $wpdb->get_results("SELECT datum, cas, typ, dostupnost FROM $table_name ORDER BY datum, cas");

    if ($slots) {
        echo '<ul>';
        foreach ($slots as $slot) {
            $label = sprintf('%s – %s (%s)', esc_html($slot->datum), esc_html($slot->cas), esc_html($slot->dostupnost));
            echo '<li>' . $label . '</li>';
        }
        echo '</ul>';
    } else {
        echo '<p>' . __('Žádné termíny zatím nejsou zadány.', 'nova-rezervace') . '</p>';
    }
    ?>
</div>
