<?php
if (!defined('ABSPATH')) exit;

// Zpracovn POST  uloen licennho kle
if (isset($_POST['bs_license_key'])) {
    check_admin_referer('bs_license_save', 'bs_nonce');

    $license_key = sanitize_text_field($_POST['bs_license_key']);
    update_option('bs_license_key', $license_key);

    // Me sem pidat voln funkce pro oven licence, nap.:
    // bs_verify_license($license_key);

    echo '<div class="notice notice-success is-dismissible">
        <p>' . __('Licenn kl byl uloen.', 'moje-rezervace') . '</p>
    </div>';
}

// Naten uloenho kle
$current_key = get_option('bs_license_key', '');
?>

<div class="wrap">
    <h1><?php echo esc_html__('Aktivace licennho kle', 'moje-rezervace'); ?></h1>
    <form method="post" action="">
        <?php wp_nonce_field('bs_license_save', 'bs_nonce'); ?>

        <table class="form-table">
            <tr>
                <th scope="row"><?php echo esc_html__('Licenn kl', 'moje-rezervace'); ?></th>
                <td>
                    <input type="text" name="bs_license_key" value="<?php echo esc_attr($current_key); ?>" class="regular-text" />
                    <p class="description"><?php echo esc_html__('Zadejte svj licenn kl pro aktivaci pluginu.', 'moje-rezervace'); ?></p>
                </td>
            </tr>
        </table>

        <?php submit_button(__('Uloit kl', 'moje-rezervace')); ?>
    </form>
</div>