
<?php
if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;
$table_name = $wpdb->prefix . 'rezervace';

// 📦 Zpracování hromadného formuláře
if ($_SERVER['REQUEST_METHOD'] === 'POST' && check_admin_referer('bulk_slot_nonce', 'bulk_slot_nonce_field')) {

    $start = new DateTime(sanitize_text_field($_POST['start_date']));
    $end   = new DateTime(sanitize_text_field($_POST['end_date']));
    $cas   = sanitize_text_field($_POST['slot_time']);
    $dny   = $_POST['days'] ?? [];

    $added = [];
    $skipped = [];

    while ($start <= $end) {
        $den = $start->format('D'); // Mon, Tue, Wed...
        if (in_array($den, $dny)) {
            $datum = $start->format('Y-m-d');

            $existuje = $wpdb->get_var($wpdb->prepare(
                "SELECT COUNT(*) FROM $table_name WHERE datum = %s AND cas = %s",
                $datum, $cas
            ));

            if ($existuje == 0) {
                $wpdb->insert($table_name, [
                    'datum' => $datum,
                    'cas' => $cas,
                    'typ' => 'hromadna',
                    'dostupnost' => 'volny',
                    'jmeno' => '',
                    'email' => '',
                    'mobil' => '',
                    'zprava' => '',
                    'potvrzeno' => 0
                ]);
                $added[] = "$datum $cas";
            } else {
                $skipped[] = "$datum $cas";
            }
        }
        $start->modify('+1 day');
    }

    // Výpis výsledků
    echo '<div class="notice notice-success"><p>';
    printf(__('✅ Přidáno: %d slotů.', 'nova-rezervace'), count($added));
    echo '</p></div>';

    if (!empty($skipped)) {
        echo '<div class="notice notice-warning"><p>';
        echo __('Přeskočené termíny (už existují):', 'nova-rezervace') . ' ' . implode(', ', $skipped);
        echo '</p></div>';
    }
}
?>

<div class="wrap">
    <h2><?php _e('Hromadné zadání dostupných termínů', 'nova-rezervace'); ?></h2>

    <form method="post" action="">
        <?php wp_nonce_field('bulk_slot_nonce', 'bulk_slot_nonce_field'); ?>
        <table class="form-table">
            <tr>
                <th><label for="start-date"><?php _e('Od data', 'nova-rezervace'); ?></label></th>
                <td><input type="date" id="start-date" name="start_date" required></td>
            </tr>
            <tr>
                <th><label for="end-date"><?php _e('Do data', 'nova-rezervace'); ?></label></th>
                <td><input type="date" id="end-date" name="end_date" required></td>
            </tr>
            <tr>
                <th><label for="slot-time"><?php _e('Čas rezervace', 'nova-rezervace'); ?></label></th>
                <td><input type="time" id="slot-time" name="slot_time" required></td>
            </tr>
            <tr>
                <th><label for="days"><?php _e('Dny v týdnu', 'nova-rezervace'); ?></label></th>
                <td>
                    <?php
                    $week_days = [
                        'Mon' => __('Po','nova-rezervace'), 'Tue' => __('Út','nova-rezervace'),
                        'Wed' => __('St','nova-rezervace'), 'Thu' => __('Čt','nova-rezervace'),
                        'Fri' => __('Pá','nova-rezervace'), 'Sat' => __('So','nova-rezervace'),
                        'Sun' => __('Ne','nova-rezervace')
                    ];

                    foreach ($week_days as $key => $label) {
                        echo '<label><input type="checkbox" name="days[]" value="' . esc_attr($key) . '"> ' . esc_html($label) . '</label> ';
                    }
                    ?>
                </td>
            </tr>
        </table>

        <p><button type="submit" class="button button-primary"><?php _e('Vygenerovat termíny', 'nova-rezervace'); ?></button></p>
    </form>

    <hr>

    <h3><?php _e('Ukázka vygenerovaných termínů', 'nova-rezervace'); ?></h3>
    <ul id="bulk-preview-list">
        <?php
        if (!empty($added)) {
            foreach ($added as $slot) {
                echo '<li>' . esc_html($slot) . '</li>';
            }
        }
        ?>
    </ul>
</div>
