<?php
if (!defined('ABSPATH')) exit;

// ------------------------------------------------------
// Zpracování AJAX testovacího e-mailu
// ------------------------------------------------------
add_action('wp_ajax_mr_send_test_email', function() {
    check_ajax_referer('mr_nonce', 'nonce');

    $to = get_option('from_email');
    $subject = 'Testovací e-mail ze systému rezervací';
    $message = '<p>Tento e-mail slouží k otestování SMTP nastavení.</p>';
    $message .= '<p>Datum a čas: ' . date('Y-m-d H:i:s') . '</p>';

    if (function_exists('mr_posli_email') && mr_posli_email($to, $subject, $message)) {
        wp_send_json_success("✅ Testovací e-mail byl odeslán na {$to}.");
    } else {
        wp_send_json_error("❌ Odeslání testovacího e-mailu se nezdařilo. Zkontrolujte SMTP nastavení.");
    }
});
?>
 <div class="wrap">
<div class="mr-email-settings">
    <div class="nova-box">
        <div class="nova-box-header">
            <h1>Nastavení e-mailové schránky</h1>
            <p>Vyplňte údaje pro odesílání e-mailů přes SMTP server.</p>
        </div>

        <form id="mr-email-settings-form" method="post" action="">
            <?php wp_nonce_field('moje_email_nastaveni_nonce', 'moje_email_nastaveni_nonce_field'); ?>

            <div class="nova-form-table">

                <div class="nova-form-row">
                    <label for="from_name">
                        Jméno odesílatele:
                        
                    </label>
                    <input type="text" name="from_name" value="<?php echo esc_attr(get_option('from_name')); ?>" required>
                <span class="help-box" data-tooltip="Jméno, které uvidí příjemce – například vaše firma.">i</span>
                </div>

                <div class="nova-form-row">
                    <label for="from_email">
                        E-mail odesílatele:
                        
                    </label>
                    <input type="email" name="from_email" value="<?php echo esc_attr(get_option('from_email')); ?>" required>
                <span class="help-box" data-tooltip="Kam budou chodit zprávy. Zkontrolujte správnost e-mailu.">i</span>
                </div>

                <div class="nova-form-row">
                    <label for="smtp_host">
                        SMTP server:
                        
                    </label>
                    <input type="text" name="smtp_host" value="<?php echo esc_attr(get_option('smtp_host')); ?>" required>
                <span class="help-box" data-tooltip="Adresa serveru pro odesílání e-mailů (např. smtp.gmail.com).">i</span>
                </div>

                <div class="nova-form-row">
                    <label for="smtp_port">
                        SMTP port:
                        
                    </label>
                    <input type="number" name="smtp_port" value="<?php echo esc_attr(get_option('smtp_port')); ?>" required>
                <span class="help-box" data-tooltip="Obvykle 465 (SSL) nebo 587 (TLS).">i</span>
                </div>

                <div class="nova-form-row">
                    <label for="smtp_user">
                        SMTP uživatel:
                       
                    </label>
                    <input type="text" name="smtp_user" value="<?php echo esc_attr(get_option('smtp_user')); ?>" required>
               <span class="help-box" data-tooltip="Uživatelské jméno, často stejné jako e-mailová adresa.">i</span>
                
                </div>

                <div class="nova-form-row">
                    <label for="smtp_pass">
                        SMTP heslo:
                        
                    </label>
                    <input type="password" name="smtp_pass" value="<?php echo esc_attr(get_option('smtp_pass')); ?>" required>
                <span class="help-box" data-tooltip="Heslo nebo aplikační klíč k e-mailu.">i</span>
                </div>

                <div class="nova-form-row">
                    <label for="smtp_secure">
                        Šifrování:
                       
                    </label>
                    <select name="smtp_secure">
                        <option value="none" <?php selected(get_option('smtp_secure'), 'none'); ?>>Žádné</option>
                        <option value="ssl" <?php selected(get_option('smtp_secure'), 'ssl'); ?>>SSL</option>
                        <option value="tls" <?php selected(get_option('smtp_secure'), 'tls'); ?>>TLS</option>
                    </select><span class="help-box" data-tooltip="Vyberte zabezpečení: SSL, TLS nebo žádné.">i</span>
                </div>

            </div>

            <div class="nova-form-actions">
                <button type="submit" name="save_settings" class="button button-primary">Uložit nastavení</button>
                <button type="button" id="mr-send-test-email" class="button">Odeslat testovací e-mail</button>
            </div>

            <div id="mr-email-result"></div>
        </form>
    </div>
</div>

<script>
const form = document.getElementById('mr-email-settings-form');
const result = document.getElementById('mr-email-result');

form.addEventListener('submit', function(e){
    e.preventDefault();
    result.textContent = '⏳ Ukládám nastavení...';

    const formData = new FormData(form);
    formData.append('action','mr_save_email_settings');
    formData.append('nonce','<?php echo wp_create_nonce("mr_nonce"); ?>');

    fetch(ajaxurl, { method:'POST', body: formData })
        .then(res=>res.json())
        .then(data=>{
            result.textContent = data.success ? data.data : '❌ '+data.data;
        })
        .catch(err=>{
            result.textContent = '❌ Došlo k chybě při ukládání.';
            console.error(err);
        });
});



document.addEventListener('DOMContentLoaded', function () {
    const btn = document.getElementById('mr-send-test-email');
    const result = document.getElementById('mr-email-result');

    btn.addEventListener('click', function () {
        result.textContent = '⏳ Odesílám e-mail...';

        fetch(ajaxurl, {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                action: 'mr_send_test_email',
                nonce: '<?php echo wp_create_nonce("mr_nonce"); ?>'
            })
        })
        .then(res => res.json())
        .then(data => {
            if(data.success){
                result.innerHTML = data.data;
            } else {
                result.innerHTML = data.data;
            }
        })
        .catch(err => {
            result.textContent = '❌ Došlo k chybě při odesílání e-mailu.';
            console.error(err);
        });
    });
});
</script>
