<?php
if (!defined('ABSPATH')) exit;

// 🔧 Uložení nastavení
if (isset($_POST['mr_save_calendar_settings'])) {

    // Barva banneru
    update_option('mr_calendar_color', isset($_POST['calendar_color']) ? sanitize_hex_color($_POST['calendar_color']) : '#3a87ad');

    // Nadpis banneru
    update_option('mr_calendar_banner_title', sanitize_text_field($_POST['mr_calendar_banner_title'] ?? ''));

    // Barva nadpisu
    update_option('mr_calendar_banner_title_color', sanitize_hex_color($_POST['mr_calendar_banner_title_color'] ?? '#ffffff'));

    // Font – zachování apostrofů i mezer
    update_option('mr_calendar_font', isset($_POST['calendar_font']) ? wp_strip_all_tags($_POST['calendar_font']) : 'Arial, sans-serif');

    // Banner (URL do obrázku)
    update_option('mr_calendar_banner', isset($_POST['mr_calendar_banner']) ? esc_url_raw($_POST['mr_calendar_banner']) : '');

    // Funkce kalendáře
    update_option('mr_calendar_show_legend', isset($_POST['calendar_show_legend']) ? 1 : 0);
    update_option('mr_calendar_show_weekend', isset($_POST['calendar_show_weekend']) ? 1 : 0);

    echo '<div class="updated"><p>Nastavení bylo úspěšně uloženo.</p></div>';
}


// 🔹 Načtení hodnot
$calendar_color        = get_option('mr_calendar_color', '#3a87ad');
$calendar_font         = get_option('mr_calendar_font', 'Arial, sans-serif');
$calendar_banner       = get_option('mr_calendar_banner', '');
$calendar_show_legend  = get_option('mr_calendar_show_legend', 1);
$calendar_show_weekend = get_option('mr_calendar_show_weekend', 1);
$calendar_banner_title = get_option('mr_calendar_banner_title', '');
$calendar_banner_title_color = get_option('mr_calendar_banner_title_color', '#ffffff');


?>
<div class="wrap">
    <h1>🗓️ Nastavení kalendáře</h1>

    <form method="post" enctype="multipart/form-data">
        <table class="form-table">

            <tr><th colspan="2"><h2>🎨 Vzhled</h2></th></tr>

            <tr>
                <th>Barva banneru</th>
                <td><input type="color" name="calendar_color" value="<?php echo esc_attr($calendar_color); ?>"></td>
            </tr>

            <tr>
                <th>Font písma</th>
                <td>
                    <select name="calendar_font">
                        <option value="Arial, sans-serif" <?php selected($calendar_font, 'Arial, sans-serif'); ?>>Arial</option>
                        <option value="'Open Sans', sans-serif" <?php selected($calendar_font, "'Open Sans', sans-serif"); ?>>Open Sans</option>
                        <option value="'Roboto', sans-serif" <?php selected($calendar_font, "'Roboto', sans-serif"); ?>>Roboto</option>
                        <option value="'Times New Roman', serif" <?php selected($calendar_font, "'Times New Roman', serif"); ?>>Times New Roman</option>
                    </select>
                </td>
            </tr>

            <tr><th colspan="2"><h2>⚙️ Funkce kalendáře</h2></th></tr>

            <tr valign="top">
                <th scope="row">Banner kalendáře</th>
                <td>
                    <input type="text" name="mr_calendar_banner" id="mr_calendar_banner"
                           value="<?php echo esc_attr($calendar_banner); ?>"
                           class="regular-text" readonly>
                    <button class="button" id="upload-banner-button">Nahrát obrázek</button>

                    <div id="banner-preview" style="margin-top:10px; <?php echo $calendar_banner ? '' : 'display:none;'; ?>">
                        <?php if ($calendar_banner): ?>
                            <img src="<?php echo esc_url($calendar_banner); ?>" alt="Banner náhled" style="max-width:300px; display:block; margin-bottom:10px;">
                            <button type="button" class="button button-secondary" id="delete-banner-button">Smazat banner</button>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
         <tr>
    <th>Nadpis banneru</th>
    <td>
        <input type="text" name="mr_calendar_banner_title" 
               value="<?php echo esc_attr(get_option('mr_calendar_banner_title','')); ?>" 
               class="regular-text"></td>
            </tr>
         <tr>
    <th>Barva nadpisu banneru</th>
    <td>
        <input type="color"
               name="mr_calendar_banner_title_color"
               value="<?php echo esc_attr(get_option('mr_calendar_banner_title_color', '#ffffff')); ?>">
        <p class="description">Vyber barvu textu, který se zobrazuje v banneru.</p>
    </td>
</tr>
   <tr>
        <th>Zobrazit legendu</th>
                <td><input type="checkbox" name="calendar_show_legend" value="1" <?php checked($calendar_show_legend,1); ?>></td>
            </tr>

            <tr>
                <th>Zobrazit víkend</th>
                <td><input type="checkbox" name="calendar_show_weekend" value="1" <?php checked($calendar_show_weekend,1); ?>></td>
            </tr>

        </table>

        <p><input type="submit" name="mr_save_calendar_settings" class="button-primary" value="💾 Uložit nastavení"></p>
    </form>
</div>

<script>
jQuery(document).ready(function($){
    // ✅ WordPress Media Uploader
    var mediaUploader;

    $('#upload-banner-button').click(function(e){
        e.preventDefault();

        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        mediaUploader = wp.media.frames.file_frame = wp.media({
            title: 'Vyber banner',
            button: { text: 'Použít tento obrázek' },
            multiple: false
        });

        mediaUploader.on('select', function(){
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#mr_calendar_banner').val(attachment.url);
            $('#banner-preview').html('<img src="'+attachment.url+'" style="max-width:300px; display:block; margin-bottom:10px;"><button type="button" class="button button-secondary" id="delete-banner-button">Smazat banner</button>').show();
        });

        mediaUploader.open();
    });

    // ✅ Smazání banneru
    $(document).on('click','#delete-banner-button',function(){
        if(confirm('Opravdu chceš smazat tento banner?')) {
            $('#mr_calendar_banner').val('');
            $('#banner-preview').fadeOut();
        }
    });
});
</script>
